<?php
/**
* @version		$Id: multifldrlist.php 14401 2011-03-10 14:10:00Z ml $
* @package		Auto_Purge_Cache
* @subpackage	Parameter - adds multi-select parameter option
* @copyright	Copyright (C) 2011 MLWebTechnologies. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

class JElementMultiFldrList extends JElement
{

	var	$_name = 'MultiFldrList';

	function fetchElement($name, $value, &$node, $control_name)
	{
		jimport( 'joomla.filesystem.folder' );

		$path		= JPATH_ROOT.DS.$node->attributes('directory');
		$filter		= $node->attributes('filter');
		$exclude	= $node->attributes('exclude');
		$folders	= JFolder::folders($path, $filter);
    $ctrl = $control_name.'['.$name.']';
    
		$options = array ();
		foreach ($folders as $folder)
		{
			if ($exclude)
			{
				if (preg_match( chr( 1 ) . $exclude . chr( 1 ), $folder )) {
					continue;
				}
			}
			$options[] = JHTML::_('select.option', $folder, $folder);
		}

		if (!$node->attributes('hide_none')) {
			array_unshift($options, JHTML::_('select.option', '-1', '- '.JText::_('Do not use').' -'));
		}

		if (!$node->attributes('hide_default')) {
			array_unshift($options, JHTML::_('select.option', '', '- '.JText::_('Use default').' -'));
		}

    $attribs = ' ';
    if ($v = $node->attributes('size')) {
      $attribs .= 'size="'.$v.'"';
    }
    if ($v = $node->attributes('class')) {
      $attribs .= 'class="'.$v.'"';
    } else {
      $attribs .= 'class="inputbox"';
    }
    if ($m = $node->attributes('multiple')) {
      $attribs .= ' multiple="multiple"';
      $ctrl .= '[]';
    }

		return JHTML::_('select.genericlist',  $options, $ctrl, $attribs, 'value', 'text', $value, $control_name.$name);
	}
}
