/**
 * 	Copyright 2011
 *  This file is part of JGooMap.
 *
 *  JGooMap is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  JGooMap is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with JGooMap.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Created on Oct 8, 2009
 * @author James Hansen(Kermode Bear Software)
 *
 */

/**
 * @params ops - OPtion for the control.
 * ops.onDrag Called when the map is resizing, funciton(map, event) Google map, mouse event.
 * ops.onDragEnd Called when the map has stop resizing. funciton(map,event)
 * ops.image = True enables default image, otherwise uses Text in the resize control.
 * ops.text = Resize control name.
 * ResizeControl.image Set this to a user defined image for the resize control.  
 */
function ResizeControl(ops){
	this.image = new Image();
	var that = this;
	if(!ops){
		ops = {text : 'Resize', width : 40, height: 20 , background : '#FFFFFF'};
	}
	
	
	this.ops = ops;
	this.image.onload = function (){
		ops.width = that.image.width;
		ops.height = that.image.height;
	};
	
	this.image.src = 'images/resize.gif';	
	
	this.ops.text = ops.text || 'Resize';
	this.onDrag = ops.onDrag || function (){};
	this.onDragEnd = ops.onDragEnd || function() {};
	ResizeControl.MIN_WIDTH = 100;
	ResizeControl.MIN_HEIGHT = 100;
}


/**
 * Create Information width displays width and height of window as the control is dragged.
 * @param map The controls map.
 * TODO: This is not showing in Google v.3
 */
ResizeControl.prototype.createInfoDiv = function(map){
	var container = map.getDiv();
	var info = document.createElement('div');
	info.id="resizeIntoDiv";
	this.info = info;
	var widthDiv = document.createElement('div');
	var heightDiv = document.createElement('div');
	widthDiv.id = 'resizeWidth';
	heightDiv.id = 'resizeHeight';
	info.appendChild(widthDiv);
	info.appendChild(heightDiv);
	info.style.backgroundColor = '#FFF';
	info.style.visibility = 'hidden';
	info.style.position = 'absolute';
	info.style.fontSize = '8pt';
	info.style.width = '48px';
	
	container.appendChild(info);
};

/**
 * Initialize the control on the map. 
 * @param map
 */
ResizeControl.prototype.initialize = function(map){
	var div = this.createControl(map);
	var that = this;
	var container = map.getDiv();
	this.createInfoDiv(map);
	
	
	this.draggable = new Drag.Move(div, 
		{	container : false , 
			onDrag : function (el){
				if(that.ops.onDrag){
					var width = parseInt(div.style.width);
					var height = parseInt(div.style.height);

					// Right and Bottom x,y pair of the div.
					var x = parseInt( div.style.left) + width;
					var y = parseInt( div.style.top) + height;
					
					// Keep map from getting too small, real small.
					if(x < ResizeControl.MIN_HEIGHT){
						x = ResizeControl.MIN_HEIGHT;
						div.style.left = x - width + 'px';
					}
					
					if(y < ResizeControl.MIN_HEIGHT) {
						y = ResizeControl.MIN_HEIGHT;
						div.style.top = y - width + 'px';
					}
					
					// Set the width of the container and resize map.
					container.style.width = x + 'px';
					container.style.height = y + 'px';
					
					// Update scrollbars if map goes outside viewing area.
					that.updateScrollBars( map );
					that.updateInfo( map );
					// Call the onDrag call back event
					google.maps.event.trigger(map, 'resize');
					that.onDrag(map);
				}
			},
			onStart : function(el){
				var size = $(container).getSize();
				that.info.childNodes[0].innerHTML = 'W: ' + size.size.x;
				that.info.childNodes[1].innerHTML = 'H: ' + size.size.y;
				that.info.style.top = parseInt(div.style.top) + 32 + 'px';
				that.info.style.left = parseInt(div.style.left) + 32 + 'px';
				that.info.style.visibility = 'visible';				
			},
			onComplete : function (el){
				that.onDragEnd(map);
				that.info.style.visibility = 'hidden';
			}
		}
	);
	
	this.moveTo = function(x,y){
		var size  = $(div).getSize();
		
		div.style.left = (x - size.size.x ) + 'px';
		div.style.top = (y - size.size.y) + 'px';
	};
	
	this.div = div;
	
	container.appendChild(div);
	
	return div;
};


/**
 * Create div control icon.
 * @param map
 */
ResizeControl.prototype.createControl = function(map){
	// Initialize the draggabel div.
	var container = map.getDiv();
	var div = document.createElement('div');
	div.title = 'Resize';
	div.style.position = 'absolute';
	if(this.ops.image){
		div.style.width = '32px';
		div.style.height = '32px';
		
		div.appendChild(this.image);
	}else{
		div.style.border = '1px solid #000';
		div.innerHTML = this.ops.text;
		div.style.backgroundColor = this.ops.background;
		div.style.width = this.ops.width + 'px';
		div.style.height = this.ops.height + 'px';
	}
	var top = (parseInt(container.style.height) - 32) + 'px';
	var left = (parseInt(container.style.width) - 32) + 'px';
	div.style.top = top; 
	div.style.left = left;
	div.style.zIndex = 100;
	div.style.cursor = 'pointer';
	return div;
};

/**
 * Update the scrollbar position base upon where the resize control's position.
 * @param map Google GMap2 object.
 */
ResizeControl.prototype.updateScrollBars = function(map){
	var container = map.getDiv();
	
	var conX = container.offsetLeft;
	var conY = container.offsetTop;
	var width = $(container).getSize().size.x;
	var height = $(container).getSize().size.y;
	var x = conX - window.getClientWidth() + 50 + width;
	var y = conY - window.getClientHeight() + 50 + height; 
	window.scrollTo( x, y);
};

/**
 * Updates the Info Div for Width and height of the map.
 * @param map
 */
ResizeControl.prototype.updateInfo = function(map){
	var container = $(map.getDiv()).getSize();
	this.info.childNodes[0].innerHTML = 'W: ' + container.size.x;
	this.info.childNodes[1].innerHTML = 'H: ' + container.size.y;
	this.info.style.left = parseInt(this.div.style.left) + 32 + 'px';
	this.info.style.top = parseInt(this.div.style.top) + 32 + 'px';
};

/**
 * Get the width of the innerClient area of the window.
 */
window.getClientWidth = function(){
	if(window.innerWidth)
		return window.innerWidth;

	return document.documentElement.clientWidth;
};

/**
 * Ge the height of the inner client area of the window.
 */
window.getClientHeight = function(){
	if(window.innerHeight)
		return window.innerHeight;

	return document.documentElement.clientHeight;
};

/**
 * Resize the map by dx,dy.
 * @param map
 * @param dx
 * @param dy
 * @param minWidth  Minimum height and width of the map.
 * @param minHeight
 * @return
 */
function resizeMap(map, dx,dy, minWidth, minHeight){
	var container = map.getDiv();
	
	var width = parseInt(container.style.width) + dx;
	var height = parseInt(container.style.height) + dy;
	
	if(width < minWidth){
		width = minWidth;
	}
	if(height < minHeight){
		height = minHeight;
	}
	
	container.style.width = width + 'px';
	container.style.height = height + 'px';
}
