<?php
/**
 * Created on Aug 11, 2009
 *
 * This is link file for helping install a plugin /component/ module.
 * Example:
 * <param type="help" link="plugins/editors-xtd/igoomap/manual/install.html" popup="yes" label="Help" text="Install" />
 *
 * link - is an relative link to the joomla base directory.
 * [text] - Optional name of the link Default text is Click Me!
 * [target] - Yes - Display popup window in a _blank target.
 * [popup] - 'yes' Opens a javascript popup window. Width and height of the window can be set.
 * [width] Default: 320
 * [height] Dimension of the window, Default height: 240
 */
 class JElementHelp extends JElement{
	var $_name = "Help";


	function fetchElement  ( $name,  $value,  &$xmlElement,  $control_name){

		$link = JURI::root() . $xmlElement->attributes('href');
		$text = $xmlElement->attributes('text') ? $xmlElement->attributes('text') : 'Click Me!';
		$attributes = array();
		$target = $xmlElement->attributes('target');

		if($target){
			$attributes['target'] = '_blank';
		}

		if ( $xmlElement->attributes('popup') === 'yes'  ){
			$width = $xmlElement->attributes('width');
			$height = $xmlElement->attributes('height');
			if(!$width) $width = 320;
			if(!$height) $height = 240;

			$js = 'function openWindow(url, width, height){
				window.open(url,"myWindow", "menubar=0,scrollbars=1,width=" + width + ",height=" + height);
				return false;
			}';
			$doc =& JFactory::getDocument();
			$doc->addScriptDeclaration($js);
			$attributes['onclick'] = "return openWindow( '{$link}', $width, $height);";
		}

		return JHTML::_('link', $link, $text, $attributes);
	}


 }
?>