/**
 * 
 */
window.addEvent('domready', function(){
	$('search_location').addEvent('keydown', function(event) {
		if(event.key == 'enter') {
		}
	});

	$('searchBtn').addEvent('click', function(){
//		var map = showMap();
		map = null;
		searchlocation(map);

	});
});

var marker;

function showMap(){
	var mapWidth = 400;
	var mapHeight = 300;
	var padding = 20;
	var width = mapWidth + padding;
	var height = mapHeight + padding;
	var lat = $('paramslat').value;
	var lng = $('paramslng').value;
	var el = $('search_location');
	var pos = el.getPosition();
	var size = getWindowSize();
	var left = size.x / 2 - width/2;
	var top = size.y/2 - height/2;
	var outerDiv = new Element('div', {
		'styles': {
			'background': '#fff',
			'position': 'absolute',
			'width' : mapWidth + 'px',
			'height' : mapHeight + 'px',
			'padding' : padding + 'px',
			'left' : left + 'px',
			'top' : top + 'px',
			'text-align': 'center'
		}
	} );
	var mapEl = new Element('div', {
		'id' : 'igoomap',
		'styles': {
			'width' : mapWidth + 'px',
			'height' : mapHeight + 'px'
		}
	});
	mapEl.inject(outerDiv);
	outerDiv.inject($$('body')[0]);
	
	var mapOptions = {
			center : new google.maps.LatLng( lat, lng ),
			zoom : 4,
			mapTypeControl: false
			}
     var   map = new google.maps.Map(document.getElementById("igoomap"), mapOptions);	return map;
     return map;
}

function searchlocation(map){
	var el = $('search_location');
	var value = el.value;
	var request = { address : value };
	if(!value) return;
	var geocoder = new google.maps.Geocoder();
	var waitImage = new Element('img', {
		'src': '../plugins/editors-xtd/igoomap/images/ajax-loader.gif'
	});
	
	waitImage.injectAfter(el);
		
	geocoder.geocode(request, function ( results ,status ){
		waitImage.remove();
		if (status == google.maps.GeocoderStatus.OK) {
			latlng = results[0].geometry.location;
//	        map.setCenter(latlng);
	        $('paramslat').value = latlng.lat();
	        $('paramslng').value = latlng.lng();
	        showSearchResults(results);
	        if(marker){
//				marker.setTitle(results[0].formatted_address);
//				marker.setPosition(latlng);
	        }else{
//		        marker = new google.maps.Marker({
//		        	map: map,
//		            position: latlng,
//		            title : results[0].formatted_address
//		        });
	        }
	    } else {
	    	alert('Geocode was not successful for the following reason: ' + status);
		}

	});

}


/**
 * 
 * @param results Geocoder results.
 */
function showSearchResults(results){
	var width = 300; // Popup div.
	var el = $('mapResults');
	if(el) el.remove();
	
	el = $('search_location');
	var pos = el.getPosition();
	var div = new Element('div', 
		{ 	'id' : 'mapResults',
			'styles' : { 	'background': '#fff',
						'border': '1px solid #303030',
						'border-radius': '5px',
						'-webkit-border-radius': '5px',
						'-moz-border-radius': '5px',
						'margin': '3px',
						'width': width + 'px',
						'padding': '3px',
						'position': 'absolute',
					 	'left': pos.x - width + 'px',
					 	'top': pos.y + 'px'
					 }
	});
	
	var titlebar = new Element('div', { 
		'styles': { 
			'border-radius': '5px',
			'-webkit-border-radius': '5px',
			'-moz-border-radius': '5px',
			'background': '#F5F5F5', 
			'border': '1px solid #d0d0d0',
			'overflow':'auto',
			'cursor': 'move'
			}
		});
	
	titlebar.injectInside(div);

	var drEl = new Element('div', { 'styles': {float : 'left','margin': '3px 14%', 'text-align':'center'}});
	drEl.setHTML('Drag Me From Here');
	
	div.makeDraggable({ handle : titlebar});
	var h = new Element('h4', { 'styles' : { 'float': 'left','margin': '3px'}}).setHTML('Results').inject(titlebar);
	drEl.inject(titlebar);
	var a = new Element('a', { 'styles' : { 'color': 'blue','float': 'right','display':'block','margin': '3px'}});
	a.setHTML('Close');
	a.inject(titlebar);
	a.addEvent('click', function(){
		var fxdiv = new Fx.Style(div, 'opacity', {duration: 250, onComplete : function(){div.remove();} });
		fxdiv.start(1,0);
	});
	var help = new Element('div', { 'styles': { 'font' : '14px bold', 'line-height':'20px'  } }).injectInside(div);
	help.setHTML('Click on result row to view location in Map');
	var currentResult = null;
	for(var i = 0; i < results.length; i++){
		var result = results[i];
		var re = new Element('div', { 'styles' : { 'border-top': '1px solid #404040', 'padding': '3px'}});
		re.setHTML(result.formatted_address);
		var latlng =  result.geometry.location;
		re.latlng =   result.geometry.location;
		if(i ==0){
			re.style.background = '#99B3CC'; // highlight first position
			currentResult = re;
		}
		
		re.addEvent('click', function(){
			this.oldBg = '#99B3CC';
			currentResult.style.background = '#fff'; // remove old highlight
			currentResult = this;
			this.style.background = '#99B3CC'; // highlight current
			$('paramslat').value = this.latlng.lat();
		    $('paramslng').value = this.latlng.lng();
//			map.panTo(this.latlng);
			
		});
		re.addEvent('mouseover', function () {
			this.oldBg = this.style.background;
			this.style.background = '#DFF0FF'; 
		} );
		re.addEvent('mouseout', function () {
			this.style.background = this.oldBg;
		} );
		re.injectInside(div);
	}
	div.setStyle('opacity', 0);
	div.injectInside($$('body')[0]);
	new Fx.Style(div, 'opacity', { duration: 250 }).start(0,1);
	
}

function getWindowSize(){
	var size;
	if (typeof window.innerWidth != 'undefined'){
		size = { x : window.innerWidth, y : window.innerHeight };
	 }else if (typeof document.documentElement != 'undefined'
	     && typeof document.documentElement.clientWidth !=
	     'undefined' && document.documentElement.clientWidth != 0){
		 size = { x : document.documentElement.clientWidth,
				 y : document.documentElement.clientHeight };
	 } 
	
	return size;
}