(function($){

$.Controller(
    'EasyBlog.FileManager.Uploader',
    {
        defaults: {
        }
    },
    function(self) { return {

        init: function()
        {
            self.fileManager = self.options.fileManager;
            
            window.__easyblog_plupload___ = self.plupload = new plupload.Uploader(self.options.settings);

            self.plupload.bind('PostInit', self['{plupload} PostInit']);

            // Rule: Init() plupload before you bind except for postInit
            self.plupload.init();

            // Import plupload event bindings
            for (binder in self)
            {
                if (!binder.match("{plupload} ")) continue;

                eventName = binder.replace("{plupload} ", '');

                self.plupload.bind(eventName, self[binder]);
            }
        },

        // TODO: Turn start(), stop() & complete() into events that other components, e.g. toolbar, 
        //       can attach its own function when they are triggered.
        uploadMonitor: null,

        start: function()
        {
            // Take note of:
            // getFlashObj().setFileFilters is not a function
            // http://www.plupload.com/punbb/viewtopic.php?id=120
            // self.plupload.refresh();
                        
            self.fileManager.toolbar.upload.resetProgress();

            self.fileManager.toolbar.upload.activate();

            self.plupload.start();

            clearTimeout(self.uploadMonitor);
        },

        stop: function()
        {
            self.plupload.stop();

            self.complete();
        },

        complete: function()
        {
            self.fileManager.toolbar.upload.deactivate();

            clearTimeout(self.uploadMonitor);
        },

        remove: function(id)
        {
            var itemHandler = self.itemHandlers[id];

            if (!itemHandler) return;

            var file = itemHandler.options.properties;

            self.plupload.removeFile(file);

            self.fileManager.browser.removeItem(itemHandler);

            delete self.itemHandlers[id];
        },

        itemHandlers: {},

        itemHandler: function(id)
        {
            return self.itemHandlers[id];  
        },

        createItemHandler: function(file, callback)
        {
            file.type = 'upload';

            self.fileManager.browser.addItem(file, function(itemHandler)
            {
                self.itemHandlers[file.id] = itemHandler;

                return callback && callback.apply(null, [itemHandler]);
            });
        },

        "{plupload} PostInit": function(up)
        {
            self.fileManager.toolbar.upload.element
                .removeClass('init')
                .find('.wait')
                .remove();
            
            self.fileManager.toolbar.upload.setLayout();
        },

        "{plupload} FilesAdded": function(up, files)
        {
            $.each(files, function(i, file)
            {
                // The itemHandler may have been created before this,
                // e.g. when a file-based error is triggered.
                if (!self.itemHandler(file.id))
                {
                    self.createItemHandler(file);
                }
            });

            // Prevent text selection
            $(window).blur();
            
            self.start();
        },

        "{plupload} BeforeUpload": function(up, file)
        {
            self.itemHandler(file.id)
                .beforeUpload(file);
        },

        "{plupload} UploadFile": function(up, file)
        {
            self.itemHandler(file.id)
                .uploadFile(file);
        },

        "{plupload} ChunkUploaded": function(up, file)
        {            
            self.itemHandler(file.id)
                .chunkUploaded(file);
        },

        "{plupload} UploadProgress": function(up, file)
        {
            self.itemHandler(file.id)
                .uploadProgress(file);
        },

        "{plupload} FileUploaded": function(up, file, data)
        {
            var itemHandler = self.itemHandler(file.id),
                response;

            try {

                response = eval('('+data.response+')');

            } catch(e) {

                itemHandler.error(file, {
                    code: '204',
                    message: 'Invalid response from server.'
                });
            }

            if (response)
            {
                itemHandler.fileUploaded(file, response);
            }  
        },

        "{plupload} Error": function(up, error)
        {
            // File based errors
            var file = error.file;

            if (file)
            {
                try { console.log('error', file.id, file.name) } catch(err) {};

                // Get the itemHandler for this file
                var itemHandler = self.itemHandler(file.id);

                // Forward error to item handler
                if (itemHandler)
                {
                    itemHandler.error(file, error);

                // If the itemHandler is not created
                } else {

                    // Create the item handler
                    self.createItemHandler(file, function(itemHandler)
                    {
                        // Then trigger the error
                        itemHandler.error(file, error);
                    });
                }

            } else {

                // Output to console
                try { console.log('plupload Error: ', error); } catch(e) {};

            }
        },

        "{plupload} UploadComplete": function()
        {
            // Delay trigger of this event so users get to see some visual feedback
            setTimeout(function()
            {
                self.complete();

            }, 1000);   
        }
    }}
);

})(Foundry);