(function($){

$.Controller(
	'EasyBlog.FileManager',
	{
		defaults: {

			dataset: {},

			"{toolbar}": '.fileManager-toolbar',
			"{browser}": '.fileManager-browser'
		}
	},
	function(self) { return {

		init: function()
		{
			self.fixJoomlaAddingSlashes();

			// Image manager toolbar
			self.toolbar().implement(
				'EasyBlog.FileManager.Toolbar',
				{
					fileManager: self
				},
				function()
				{
					self.toolbar = this;
				}
			);

			// Image manager browser
			self.browser().implement(
				'EasyBlog.FileManager.Browser',
				{
					fileManager: self
				},
				function()
				{
					self.browser = this;
				}
			);

			// Operations
			self.element.implement(
				'EasyBlog.FileManager.Operations',
				{
					fileManager: self
				},
				function()
				{
					self.operations = this;
				}
			);

			// Uploader
			self.element.implement(
				'EasyBlog.FileManager.Uploader',
				{
					fileManager: self,
					settings: self.options.uploadSettings
				},
				function()
				{
					self.uploader = this;
				}
			);

			self.setLayout();

			self.populateDataset();
		},

		currentPath: function(absolute)
		{
			var path = self.options.path;
			return (absolute) ? path : (path.split('/').pop() || '/');
		},

		setLayout: function()
		{
			var parentFrame =  $(window.parent.document).find('#eblog-filemanager .filemanager-app');

			if (parentFrame.length < 1)
				parentFrame = $(window);

			var fileManager = this.element;
			
			fileManager
				.css('width', parentFrame.width() - (fileManager.outerWidth() - fileManager.width()))
				.css('height', parentFrame.height() - (fileManager.outerHeight() - fileManager.height()));

			this.toolbar.setLayout();

			this.browser.setLayout();
		},
		
		populateDataset: function()
		{
			$.each(self.options.dataset, function(i, data)
			{
				self.browser.addItem(data);
			});
		},

		"{window} keyup": function(el, event)
		{
			if (event.keyCode==27)
			{
				if (event.shiftKey) 
				{
					window.parent.eblog.fileManager.show();
				} else {
					window.parent.eblog.fileManager.hide();	
				} 
			}
		},

		"{window} resize": function()
		{
			this.setLayout();
		},

		fixJoomlaAddingSlashes: function()
		{
	        // Inject EJS template directly into the cache
	        $('script[type="text/ejs"]').each(function()
	        {
	        	var id = $(this).attr('id');
	        	var text = $(this)[0].innerHTML;
	        	
	        	var viewId = id.replace(/^\/\//, "").replace(/[\/\.]/g, "_");
	        	var func = $.View.types['.ejs'].renderer(viewId, text);
	        	$.View.cached[viewId] = func;

	        	$(this).remove();
	        });
		}
	}}
);
})(Foundry);