(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.PreviewHandler.Image',
	{
		defaults: {
			'{itemPreview}'     : '.item-preview',
			'{itemProperties}'  : '.item-properties',

			'{imageUrl}'         : '#image-url',
			'{imageTitle}'       : '#image-title',
			'{imageDesc}'        : '#image-desc',
			'{imageWidth}'       : '#image-width',
			'{imageHeight}'      : '#image-height',
			'{imageAspectRatio}' : '#image-aspect-ratio',
			'{imageAlign}'       : '#image-align',
			'{imageFeatured}'    : '#image-featured',
			'{imageViewButton}'  : '.image-view-button',
			'{imageInsertButton}': '.image-insert-button',
			'{imageDeleteButton}': '.image-delete-button',
			'{imageThumbnail}'	 : '#image-thumbnail',
			'@Editor': 'EasyBlog.FileManager.Browser.PreviewHandler.Image.Editor'
		}
	},
	function(self) { return {

		init: function()
		{


			self.fileManager = self.options.fileManager;
			self.meta = self.options.properties;

			self.render(function(html)
			{
				self.element.append(html);

				self.imageWidth()
					.data('default', self.meta.width)
					.numeric();

				self.imageHeight()
					.data('default', self.meta.height)
					.numeric();

				self.imageAspectRatio()
					.checked(function()
					{
						// Retrigger width/height calculation
						self.imageWidth()
							.keyup();
					});
			});
		},

		render: function(callback)
		{
			$.View(
				self.template('Editor'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},

		setLayout: function()
		{
			// Calculate image height
			var itemPreviewWidth  = self.itemPreview().width(),
				itemPreviewHeight = self.element.height() - self.itemProperties().outerHeight() - (self.itemPreview().outerHeight() - self.itemPreview().height());

			self.itemPreview().css('height', itemPreviewHeight);

			var image = self.itemPreview().find('img');

			image.load((function()
			{
				image.css(
				{
					maxWidth : itemPreviewWidth - 20,
					maxHeight: itemPreviewHeight - 20,
					opacity: 0
				})
				.position({
					my: 'center center',
					at: 'center center',
					of: self.itemPreview()
				})
				.css(
				{
					opacity: (self.loaded) ? 1 : 0
				})

				return arguments.callee;
			})());

			self.loaded = true;

			$([self.imageUrl(), self.imageTitle(), self.imageDesc()])
				.stretchToFit();
		},
		"{imageThumbnail} change" : function( element )
		{
			// If thumbnail is checked, update the width and url source to the thumbnails
			if( element.is( ':checked' ) )
			{
				self.imageUrl().val( self.options.properties.thumbnail );
				self.imageWidth().val( self.options.properties.thumbwidth );
				self.imageHeight().val( self.options.properties.thumbheight );
			}
			else
			{
				self.imageUrl().val( self.options.properties.url );
				self.imageWidth().val( self.options.properties.width );
				self.imageHeight().val( self.options.properties.height );
			}
		},

		"{imageInsertButton} click": function()
		{
			var imageData = $(new Image());

			imageData.attr({
				    'src'   : self.imageThumbnail().is( ':checked' ) ? self.itemHandler.options.properties.thumbnail : self.imageUrl().val(),
				    'title' : self.imageTitle().val(),
				    'alt'   : self.imageDesc().val(),
				    'width' : self.imageWidth().val(),
				    'height': self.imageHeight().val()
				});

			var align = self.imageAlign().val();

			if (align==="left" || align==="right") {
				imageData.attr('align', align);
			}

			if (self.imageFeatured().checked()) {
				imageData.addClass('featured');
			}

			console.log(self.imageThumbnail().checked());

			var imageHtml = (self.imageThumbnail().checked()) ?

								(function()
								{
									var link = $('<a>')
										.attr({
											'class': 'easyblog-thumb-preview',
											'href' : self.options.properties.fullpath,
											'title': self.imageTitle().val()
										});

									return link.html(imageData).toHTML();

								})() :

								imageData.toHTML();

			if (align==="center") {
				imageHtml = '<p style="text-align: center;">' + imageHtml + '</p>';
			}

			self.fileManager.operations.insertIntoEditor(imageHtml);
		},

		// TODO: Implement this feature.
		"{imageViewButton} click": function()
		{
			var imageEditorViewImage = window.open(imageUrl.val(), 'imageEditorViewImage', "location=0,menubar=0,scrollbars=1,width=640,height=480");
		},

		"{imageDeleteButton} click": function()
		{
			self.itemHandler.deleteImage();
		},

		"{imageUrl} click": function(el, event)
		{
			el.select();
		},

		"[{imageWidth}, {imageHeight}] change": function(el, event)
		{
			// Reset width & height to default value if no value given
            if ($.trim(el.val())=='') el.val(el.data('default'));
		},

		"[{imageWidth}, {imageHeight}] keyup": function(el, event)
		{
			// Resize according to aspect ratio

			// Do not calculate if aspect ratio checkbox is not checked
			// or user is hitting the tab key.
			if (!self.imageAspectRatio().checked() || event.keyCode==9)
				return;

			var ratio = el.data('default') / (parseInt(el.val(), 10) || 0);

			self.setAspectRatio(ratio);
		},

		setAspectRatio: function(ratio)
		{
			self.imageWidth()
				.val( Math.floor(self.meta.width / ratio) );

			self.imageHeight()
				.val( Math.floor(self.meta.height / ratio) );
		}

	}}
);
})(Foundry);
