<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');
require_once( EBLOG_HELPERS . DS . 'string.php' );
require_once( EBLOG_HELPERS . DS . 'date.php' );

class EasyBlogViewTeamBlog extends EasyBlogView
{	
	var $err	= null;

    function showJoinDialog($teamId)
    {
        $my     = JFactory::getUser();
		$ejax	= new Ejax();
		$config = EasyBlogHelper::getConfig();

		if( $my->id <= 0 )
		{
			echo JText::_( 'COM_EASYBLOG_NOT_ALLOWED' );
			return;
		}
		
		$team	= EasyBlogHelper::getTable( 'TeamBlog' , 'Table' );
		$team->load( $teamId );
		
		$theme	= new CodeThemes();
		$theme->set( 'team'	, $team );

		$options		  = new stdClass();
		$options->title   = JText::_('COM_EASYBLOG_TEAMBLOG_DIALOG_JOIN_TEAM_TITLE');
		$options->content = $theme->fetch( 'ajax.dialog.team.join.php' );

		$ejax->dialog( $options );

    	$ejax->send();
    	return;

    }

    function addJoinRequest( $post )
    {
		$ejax			= new Ejax();
		$mainframe		=& JFactory::getApplication();
		$my				=& JFactory::getUser();
		$config 		=& EasyBlogHelper::getConfig();
		$now            =& JFactory::getDate();
		
		if(empty($post['id']) || $post['userid'] != $my->id || $my->id == 0)
		{
		    $ejax->script('eblog.system.loader(false);');
			$ejax->alert( JText::_('COM_EASYBLOG_NOT_ALLOWED'), JText::_('COM_EASYBLOG_ERROR') , '450', 'auto');
			$ejax->send();
		}
		
		$teamId = $post['id'];
		
		$teamBlogUser   =& EasyBlogHelper::getTable('TeamBlogUsers', 'Table');
		$teamBlogUser->team_id  = $teamId;
		$teamBlogUser->user_id  = $my->id;
		
		if($teamBlogUser->exists())
		{
		    $ejax->script('eblog.system.loader(false);');
			$ejax->alert( JText::_('COM_EASYBLOG_TEAMBLOG_ALREADY_MEMBER'), JText::_('COM_EASYBLOG_INFO') , '450', 'auto');
			$ejax->send();
			return;
		}
		
		$teamBlogRequest   =& EasyBlogHelper::getTable('TeamBlogRequest', 'Table');
		$teamBlogRequest->team_id   = $teamId;
		$teamBlogRequest->user_id   = $my->id;
		$teamBlogRequest->ispending	= '1';
		$teamBlogRequest->created	= $now->toMySQL();
		
		if($teamBlogRequest->exists())
		{
		    $ejax->script('eblog.system.loader(false);');
			$ejax->alert( JText::_('COM_EASYBLOG_TEAMBLOG_REQUEST_ALREADY_SENT'), JText::_('COM_EASYBLOG_INFO') , '450', 'auto');
			$ejax->send();
			return;
		}
		
		if($teamBlogRequest->store())
		{
		    //send email to team admin
		    $teamBlog   =& EasyBlogHelper::getTable('TeamBlog', 'Table');
		    $teamBlog->load($teamId);

			$toNotifyEmails   = $teamBlog->getTeamAdminEmails();
			
			if(count($toNotifyEmails) > 0)
			{
				$notify	=& EasyBlogHelper::getNotification();

				$emailData  = array();
				$emailData['fullname']  = $my->name;
				$emailData['team']  	= $teamBlog->title;
				$notify->sendEmails($toNotifyEmails, JText::_('COM_EASYBLOG_TEAMBLOG_NEW_REQUEST'), '', 'email.teamblog.request.php', $emailData);
			}
		
			$ejax->alert( JText::_('COM_EASYBLOG_TEAMBLOG_REQUEST_SENT'), JText::_('COM_EASYBLOG_INFO') , '450', 'auto');
		}
		else
		{
			$ejax->alert( JText::_('COM_EASYBLOG_TEAMBLOG_REQUEST_FAILED'), JText::_('COM_EASYBLOG_ERROR') , '450', 'auto');
		}
		
		$ejax->script('eblog.system.loader(false);');
        $ejax->send();
        return;

    }
}