<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

require_once( EBLOG_HELPERS . DS . 'date.php' );

class EasyBlogViewCategories extends EasyBlogView
{
	function display( $tmpl = null )
	{
		JPluginHelper::importPlugin( 'easyblog' );
		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
        $document	= JFactory::getDocument();
     	$config 	= EasyBlogHelper::getConfig();
		$my         = JFactory::getUser();
		$acl 		= EasyBlogACLHelper::getRuleSet();

		// set meta tags for latest post
		EasyBlogHelper::setMeta( META_ID_GATEGORIES, META_TYPE_VIEW );

	    //setting pathway
	    $pathway	= $mainframe->getPathway();
		if( ! EasyBlogRouter::isCurrentActiveMenu( 'categories' ) )
			$this->setPathway( JText::_('COM_EASYBLOG_CATEGORIES_BREADCRUMB') , '' );

        $sortConfig = $config->get('layout_sorting_category','latest');
        $sort		= JRequest::getCmd('sort',$sortConfig);

        $modelB		= $this->getModel( 'Blog' );
		$modelC		= $this->getModel( 'Category' );
		$modelPT	= $this->getModel( 'PostTag' );

		$menu 		= JSite::getMenu()->getActive();
		$inclusion	= '';

		if( is_object( $menu ) && stristr($menu->link , 'view=categories') !== false )
		{
			$params 	= new JParameter( $menu->params );
			$inclusion	= $params->get( 'inclusion' );
		}

		$data				= $modelC->getCategories($sort, $config->get( 'main_categories_hideempty' ) , 0 , $inclusion );
		$pagination			= $modelC->getPagination();

		// @rule: Triggers usage
		$params		= $mainframe->getParams('com_easyblog');
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');

		if(!empty($data))
		{
			for($i = 0; $i < count($data); $i++)
			{
				$row		= $data[$i];
			    $category 	= EasyBlogHelper::getTable( 'ECategory', 'Table' );
			    $category->load($row->id);

	            $row->childs = null;

	            EasyBlogHelper::buildNestedCategories($row->id, $row, false , true );

				// TODO: Parameterize initial subcategories to display. Ability to configure from backend.
				$nestedLinks = '';
				$initialLimit = ($mainframe->getCfg('list_limit') == 0) ? 5 : $mainframe->getCfg('list_limit');

				if (count($row->childs) > $initialLimit)
				{
					$initialNestedLinks = '';
					$initialRow = new stdClass();
					$initialRow->childs = array_slice($row->childs, 0, $initialLimit);

					EasyBlogHelper::accessNestedCategories($initialRow, $initialNestedLinks, '0', '', 'link', ', ');

					$moreNestedLinks = '';
					$moreRow = new stdClass();
					$moreRow->childs = array_slice($row->childs, $initialLimit);

					EasyBlogHelper::accessNestedCategories($moreRow, $moreNestedLinks, '0', '', 'link', ', ');

					// Hide more nested links until triggered
					$nestedLinks .= $initialNestedLinks;
					$nestedLinks .= '<span class="more-subcategories-toggle"> ' . JText::_('COM_EASYBLOG_AND') . ' <a href="javascript: void(0);" onclick="sQuery(this).parent().hide().next(\'.more-subcategories\').show()">' . JText::sprintf('COM_EASYBLOG_OTHER_SUBCATEGORIES', count($row->childs) - $initialLimit) . '</a></span>';
					$nestedLinks .= '<span class="more-subcategories" style="display: none;">, ' . $moreNestedLinks . '</span>';

				} else {
					EasyBlogHelper::accessNestedCategories($row, $nestedLinks, '0', '', 'link', ', ');
				}

		        $catIds     = array();
		        $catIds[]   = $row->id;
			    EasyBlogHelper::accessNestedCategoriesId($row, $catIds);

				$blogs		= $modelB->getBlogsBy( 'category' , $catIds , 'latest' , 5);

				for($j=0; $j < count($blogs); $j++)
				{
				    $blogItem   	= $blogs[$j];
				    $itemLinkageArr	= EasyBlogHelper::populateCategoryLinkage($blogItem->category_id);
					$itemLinkage	= '';

			        foreach($itemLinkageArr as $linkItem)
			        {
			        	$str    = '<a href="' . EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id='.$linkItem->id) . '">' . $linkItem->title . '</a>';
			        	$itemLinkage   .= (empty($itemLinkage)) ? $str : '&nbsp;' . '&gt;' . '&nbsp;' . $str;
			        }
			        $blogItem->nestedLink	= $itemLinkage;
			        $author					= EasyBlogHelper::getTable( 'Profile' , 'Table' );

			        $author->load( $blogItem->created_by );
			        $blogItem->author		= $author;
				}

				$row->cnt   = $modelC->getTotalPostCount($catIds);

		        if(! empty($blogs))
				{
					$blogs	= EasyBlogHelper::formatBlog( $blogs );
				}

				$row->description	= $category->get( 'description' );
				$row->blogs			= $blogs;
				$row->rssLink   	= $category->getRSS();
				$row->avatar    	= $category->getAvatar();
				$row->nestedLink    = $nestedLinks;
				$row->bloggers		= $category->getActiveBloggers();
			}
		}

		$pageTitle	= EasyBlogHelper::getPageTitle($config->get('main_title'));
		$pageNumber	= $pagination->get( 'pages.current' );
		$pageText	= ($pageNumber == 1) ? '' : ' - ' . JText::sprintf( 'COM_EASYBLOG_PAGE_NUMBER', $pageNumber );
		$document->setTitle( JText::_('COM_EASYBLOG_CATEGORIES_PAGE_TITLE') . $pageText . ' - ' . $pageTitle);

		$theme	= new CodeThemes();
		$theme->set( 'data', $data );
		$theme->set( 'currentURL'	, 'index.php?option=com_easyblog&view=categories' );
		$theme->set( 'sort', $sort );
		$theme->set( 'pagination', $pagination->getPagesLinks());
		$theme->set( 'my', $my );
		$theme->set( 'acl', $acl );

		echo $theme->fetch( 'blog.categories.php' );
	}


	/*
	 * Show all the blogs in this category
	 */
	function listings()
	{
		JPluginHelper::importPlugin( 'easyblog' );
		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
        $document	= JFactory::getDocument();
        $config 	= EasyBlogHelper::getConfig();
		$my         = JFactory::getUser();
		$acl 		= EasyBlogACLHelper::getRuleSet();
        $sort		= JRequest::getCmd('sort', $config->get( 'layout_postorder' ) );
        $catId		= JRequest::getCmd('id','0');

	    $category = EasyBlogHelper::getTable( 'ECategory', 'Table' );
	    $category->load($catId);

	    if($category->id == 0)
	    {
	        $category->title    = JText::_('COM_EASYBLOG_UNCATEGORIZED');
	    }

	    // Set the meta description for the category
	    $document->setMetadata('description', strip_tags( $category->description ) );

	    //setting pathway
	    $pathway	= $mainframe->getPathway();


		$addRSS = true;
		if($category->private)
		{
		    if( $my->id == 0 && !$config->get('main_allowguestsubscribe'))
		    {
		        $addRSS = false;
		    }
		}

	    if( $addRSS )
	    {
		    // Add rss feed link
		    $document->addHeadLink( $category->getRSS() , 'alternate' , 'rel' , array('type' => 'application/rss+xml', 'title' => 'RSS 2.0') );
			$document->addHeadLink( $category->getAtom() , 'alternate' , 'rel' , array('type' => 'application/atom+xml', 'title' => 'Atom 1.0') );
	    }

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'categories', $category->id ) )
		{
		    if( ! EasyBlogRouter::isCurrentActiveMenu( 'categories' ) )
				$this->setPathway( JText::_('COM_EASYBLOG_CATEGORIES_BREADCRUMB') , EasyBlogRouter::_('index.php?option=com_easyblog&view=categories') );

	    	//add the pathway for category
	    	$this->setPathway( $category->title , '' );
	    }

		//get the nested categories
		$category->childs = null;

		EasyBlogHelper::buildNestedCategories($category->id, $category , false , true );

		// TODO: Parameterize initial subcategories to display. Ability to configure from backend.
		$nestedLinks = '';
		$initialLimit = ($mainframe->getCfg('list_limit') == 0) ? 5 : $mainframe->getCfg('list_limit');

		if (count($category->childs) > $initialLimit)
		{
			$initialNestedLinks = '';
			$initialRow = new stdClass();
			$initialRow->childs = array_slice($category->childs, 0, $initialLimit);

			EasyBlogHelper::accessNestedCategories($initialRow, $initialNestedLinks, '0', '', 'link', ', ');

			$moreNestedLinks = '';
			$moreRow = new stdClass();
			$moreRow->childs = array_slice($category->childs, $initialLimit);

			EasyBlogHelper::accessNestedCategories($moreRow, $moreNestedLinks, '0', '', 'link', ', ');

			// Hide more nested links until triggered
			$nestedLinks .= $initialNestedLinks;
			$nestedLinks .= '<span class="more-subcategories-toggle"> ' . JText::_('COM_EASYBLOG_AND') . ' <a href="javascript: void(0);" onclick="sQuery(this).parent().hide().next(\'.more-subcategories\').show()">' . JText::sprintf('COM_EASYBLOG_OTHER_SUBCATEGORIES', count($category->childs) - $initialLimit) . '</a></span>';
			$nestedLinks .= '<span class="more-subcategories" style="display: none;">, ' . $moreNestedLinks . '</span>';

		} else {
			EasyBlogHelper::accessNestedCategories($category, $nestedLinks, '0', '', 'link', ', ');
		}

		$catIds     = array();
		$catIds[]   = $category->id;
		EasyBlogHelper::accessNestedCategoriesId($category, $catIds);

		$category->nestedLink = $nestedLinks;

		$modelC			= $this->getModel( 'Category' );
		$category->cnt	= $modelC->getTotalPostCount( $category->id );

        $modelPT	= $this->getModel( 'PostTag' );
        $model		= $this->getModel( 'Blog' );
		$modelCat	= $this->getModel( 'Category' );
		$data		= $model->getBlogsBy('category', $catIds, $sort );
		$pagination	= $model->getPagination();

		//for trigger
		$params		= $mainframe->getParams('com_easyblog');
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');

        if(! empty($data))
		{
            $data	= EasyBlogHelper::formatBlog( $data );

			if($config->get('layout_showcomment', false))
			{
			    for($i = 0; $i < count($data); $i++)
			    {
			        $row   = $data[$i];

					$maxComment = $config->get('layout_showcommentcount', 3);
					$comments	= EasyBlogHelper::getHelper( 'Comment' )->getBlogComment( $row->id, $maxComment , 'desc' );
	                $comments   = EasyBlogHelper::formatBlogCommentsLite($comments);
		    		$row->comments = $comments;
			    }
			}
		}
		$teamBlogCount          = $modelCat->getTeamBlogCount( $category->id );

		$pageTitle	= EasyBlogHelper::getPageTitle($config->get('main_title'));
		$pageNumber	= $pagination->get( 'pages.current' );
		$pageText	= ($pageNumber == 1) ? '' : ' - ' . JText::sprintf( 'COM_EASYBLOG_PAGE_NUMBER', $pageNumber );
		$document->setTitle( $category->title . $pageText . ' - ' . $pageTitle);

		$themes	= new CodeThemes();

		$themes->set('category', $category );
		$themes->set('sort', $sort );
		$themes->set('blogs', $data );
		$themes->set('siteadmin', EasyBlogHelper::isSiteAdmin() );
		$themes->set( 'currentURL' , 'index.php?option=com_easyblog&view=categories&layout=listings&id=' . $category->id );
		$themes->set('pagination', $pagination->getPagesLinks());
		$themes->set('config', $config );
		$themes->set('teamBlogCount', $teamBlogCount );
		$themes->set('my', $my );
		$themes->set('acl', $acl );

		echo $themes->fetch( 'blog.category.php' );
	}
}
