<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
defined('_JEXEC') or die('Restricted access');

$team   	= ( isset( $teamId) && ! empty($teamId)) ? '&team=' . $teamId : '';
$socialPosition = $system->config->get('main_socialbutton_position');

foreach($data as $row)
{
	$showAvatar	= isset( $showAvatar ) ? $showAvatar : true;
	$isMineBlog = EasyBlogHelper::isMineBlog($row->created_by, $system->my->id);
	$siteadmin  = EasyBlogHelper::isSiteAdmin();

	$blogger	=& EasyBlogHelper::getTable( 'Profile', 'Table');
	$blogger->load( $row->created_by );

	$loadratings		= true;
	$loadsocialbutton 	= true;
	$loadtags 			= true;
	$loadfblike 		= true;
	$loadcomments		= true;
	if($system->config->get('main_password_protect', true) && !empty($row->blogpassword))
	{
		if(!EasyBlogHelper::verifyBlogPassword($row->blogpassword, $row->id))
		{
			$loadratings		= false;
			$loadsocialbutton 	= false;
			$loadtags 			= false;
			$loadfblike 		= false;
			$loadcomments		= false;
		}
	}

	// if team is empty, then we cehck against the team_id from query.
	if( isset($row->team_id) )
	{
		$team	= ( !empty( $row->team_id )) ? '&team=' . $row->team_id : '';
	}
?>
<div id="entry_<?php echo $row->id; ?>" class="blog-post article_row clearfix prel">
	<?php
	/**
	* ----------------------------------------------------------------------------------------------------------
	* Site Admin Control
	* ----------------------------------------------------------------------------------------------------------
	*/
	?>
	<?php if( $siteadmin || $isMineBlog ) : ?>
	<div class="post-admin-menu pabs gradA">
		<span class="icon-menu"></span>
		<ul class="reset-ul float-li float-l pabs admin_menu">
			<?php if($siteadmin) : ?>
			<li class="featured_add" <?php echo ($row->isFeatured) ? 'style="display:none;"' : '';?> >
				<a href="javascript:eblog.featured.add('post','<?php echo $row->id;?>');">
					<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_THIS'); ?>
				</a>
			</li>
			<li class="featured_remove" <?php echo ($row->isFeatured) ? '' : 'style="display:none;"';?> >
				<a href="javascript:eblog.featured.remove('post','<?php echo $row->id;?>');">
					<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_REMOVE'); ?>
				</a>
			</li>
			<?php endif; ?>

			<li class="edit"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write&blogid='.$row->id);?><?php echo ($system->config->get( 'layout_dashboardanchor' ) ) ? '#write-entry' : '';?>"><?php echo Jtext::_('COM_EASYBLOG_EDIT'); ?></a></li>
			<?php if($siteadmin || ($isMineBlog && $acl->rules->delete_entry)) : ?>
			<li class="delete">
				<a href="javascript:eblog.blog.confirmDelete( '<?php echo $row->id;?>' , '<?php echo $currentURL;?>' );"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_DELETE_ENTRY'); ?></a>
			</li>
			<li class="unpublish">
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&controller=dashboard&from=eblog&task=toggleBlogStatus&status=0&blogId=' . $row->id );?>"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_UNPUBLISH_ENTRY'); ?></a>
			</li>
			<?php endif; ?>
		</ul>
	</div>
	<?php endif; ?>

	<div class="post-item-s float-l">
		<?php
		/**
		* ----------------------------------------------------------------------------------------------------------
		* Author avatar
		* ----------------------------------------------------------------------------------------------------------
		*/
		?>
		<?php if ( $system->config->get('layout_avatar') && $showAvatar ) : ?>
		<div class="blog-avatar clearfix mbm">
			<div class="float-r prel">
				<?php
					if( isset( $row->team_id ) )
					{
						$teamBlog   =& EasyBlogHelper::getTable( 'TeamBlog', 'Table');
						$teamBlog->load( $row->team_id );
				?>
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=teamblog&layout=listings&id=' . $teamBlog->id ); ?>" class="avatar isTeamBlog float-l prel">
					<img src="<?php echo $teamBlog->getAvatar(); ?>" alt="<?php echo $teamBlog->title; ?>" class="avatar" width="60" height="60" />
				</a>
				<a href="<?php echo $blogger->getProfileLink(); ?>" class="avatar isBlogger float-l pabs">
					<img src="<?php echo $row->avatar; ?>" alt="<?php echo $row->displayName; ?>" class="avatar" width="30" height="30" />
				</a>
				<?php
					} else {
				?>
				<a href="<?php echo $blogger->getProfileLink(); ?>" class="avatar float-l">
					<img src="<?php echo $row->avatar; ?>" alt="<?php echo $row->displayName; ?>" class="avatar isBlogger" width="60" height="60" />
				</a>
				<?php } ?>
			</div>
		</div>
		<?php endif; ?>

		<div class="clear"></div>

		<div class="post-author">
			<span class="blog-author">
				<span class="ffg fsi fwb fss"><?php echo JText::_( 'COM_EASYBLOG_POSTED_BY' );?></span>
				<a href="<?php echo $blogger->getProfileLink();?>" class="fwb"><?php echo $row->displayName; ?></a>
				<?php echo EasyBlogTooltipHelper::getBloggerHTML( $row->created_by, array('my'=>'left top','at'=>'right bottom','of'=>array('traverseUsing'=>'prev')) ); ?>
			</span>
			<div class="fsm small">
				<span class="blog-date"><?php echo $this->formatDate( $system->config->get('layout_dateformat') , $row->created ); ?></span>
			</div>
		</div>


		<div class="post-category mtm fsm">
			<span class="ico blog-category">
				<?php echo JText::sprintf('COM_EASYBLOG_POSTED_IN_CATEGORY_NO', EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id='.$row->category_id), $row->category); ?>
			</span>
		</div>


		<?php if( $system->config->get('main_comment') && $row->totalComments !== false ) { ?>
		<div class="post-comments mts fsm">
			<span class="ico blog-comments">
				<?php if( $system->config->get('comment_disqus') ) { ?>
					<?php echo $row->totalComments; ?>
				<?php } else { ?>
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry&id='.$row->id); ?>#comments">
					<?php echo $this->getNouns( 'COM_EASYBLOG_COMMENT_COUNT' , $row->totalComments , true );?>
				</a>
				<?php } ?>
			</span>
		</div>
		<?php } ?>
	</div>


	<div class="post-item-m clearfix">
		<h3 id="title_<?php echo $row->id; ?>" class="blog-title<?php echo ($row->isFeatured) ? ' featured' : '';?> rip">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>"><?php echo $row->title; ?></a>
			<?php if( $row->isFeatured ) { ?>
			<sup class="tag-featured"><?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURED'); ?></sup>
			<?php } ?>
		</h2>

		<!-- joomla content plugin call -->
		<?php echo $row->event->afterDisplayTitle; ?>

		<div class="blog-text clearfix prel">

			<?php
			/**
			* ----------------------------------------------------------------------------------------------------------
			* Content Text
			* ----------------------------------------------------------------------------------------------------------
			*/
			?>
			<!-- joomla content plugin call -->
			<?php echo $row->event->beforeDisplayContent; ?>


			<div class="in-block width-full">
				<?php
				if ( $loadsocialbutton ) :
				// show Tweetmeme and Google Buzz if enabled
				if($socialPosition == 'top') EasyBlogHelper::showSocialButton($row,true);
				if($socialPosition == 'left' || $socialPosition == 'right') EasyBlogHelper::showSocialButton($row,true);
				endif;
				?>

				
				<?php echo $row->text; ?>
			</div>

			<?php if( $loadtags ): ?>
			<div class="blog-tags mtm mbm">
				<span class="blog-tag small"><?php echo JText::sprintf('COM_EASYBLOG_TAG_LIST', $row->tags); ?></span>
			</div>
			<?php endif; ?>

			<!-- joomla content plugin call -->
			<?php echo $row->event->afterDisplayContent; ?>

			<?php /* content copyright */ ?>
			<?php if( $system->config->get( 'layout_copyrights' ) && !empty($row->copyrights) ) { ?>
			<div class="blog-copyrights mtm">
				<div class="in clearfix">
					<span class="blog-copyrights">
						<?php echo JText::_('COM_EASYBLOG_COPYRIGHTS_PREFIX') . $row->copyrights ?>
					</span>
				</div>
			</div>
			<?php } ?>

			<?php if( $system->config->get( 'main_locations_blog_frontpage' ) ){ ?>
			<?php echo EasyBlogHelper::getHelper( 'Maps' )->getHTML( true ,
																	$row->address,
																	$row->latitude ,
																	$row->longitude ,
																	$system->config->get( 'main_locations_blog_map_width') ,
																	$system->config->get( 'main_locations_blog_map_height' ),
																	JText::sprintf( 'COM_EASYBLOG_LOCATIONS_BLOG_POSTED_FROM' , $row->address ),
																	'post_map_canvas_' . $row->id );?>
			<?php } ?>

			<?php if( $system->config->get('main_facebook_like') && $system->config->get('main_facebook_like_layout') == 'standard' && $loadfblike) : ?>
			<div class="facebook-like clearfix">
				<div id="eb-fblikes" class="align<?php echo ($this->getDirection() == 'rtl') ? 'right' : 'left'; ?>">
					<?php echo $row->facebookLike; ?>
				</div>
			</div>
			<?php endif; ?>

			<?php
			// show Tweetmeme and Google Buzz if enabled
			if( $socialPosition == 'bottom' && $loadsocialbutton)
			{
				EasyBlogHelper::showSocialButton($row,true);
			}
			?>

			<?php if( $row->readmore ){ ?>
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>" class="blog-more">
					<span><?php echo JText::_('COM_EASYBLOG_CONTINUE_READING'); ?></span>
				</a>
			<?php } ?>

			<div class="blog-meta-bottom fsm mtm">
				<div class="in clearfix">
					<?php if( $system->config->get( 'layout_hits' ) ): ?>
					<span class="blog-hits"><?php echo JText::sprintf( 'COM_EASYBLOG_HITS_TOTAL' , $row->hits ); ?></span>
					<?php endif; ?>
					<span class="blog-rating">
						<?php
						if($loadratings && $system->config->get( 'main_ratings_frontpage' ) )
						{
							echo EasyBlogHelper::getHelper( 'ratings' )->getHTML( $row->id , EBLOG_RATINGS_TYPE_ENTRY , JText::_( 'COM_EASYBLOG_RATINGS_RATE_BLOG_ENTRY') , 'blog-' . $row->id . '-ratings' , $system->config->get( 'main_ratings_frontpage_locked' ));
						}
						?>
					</span>
				</div>
			</div>

			<?php
			/**
			* ----------------------------------------------------------------------------------------------------------
			* Comment view in post listing
			* ----------------------------------------------------------------------------------------------------------
			*/
			?>

			<?php if($system->config->get('layout_showcomment', false) && $loadcomments && EasyBlogHelper::getHelper( 'Comment')->isBuiltin()) { ?>
			<?php
				$this->set( 'row' , $row );
				$this->set( 'team' , $team );
				echo $this->fetch( 'blog.item.comment.list.php' );
			?>
			<?php } ?>
		</div>
	</div><!--end: .blog-content-->
</div><!--end: .blog-post-->
<?php
}//end foreach
?>
