<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
defined('_JEXEC') or die('Restricted access');


foreach($data as $row)
{
	$showAvatar	= isset( $showAvatar ) ? $showAvatar : true;
	$isMineBlog = EasyBlogHelper::isMineBlog($row->created_by, $system->my->id);

	$blogger	=& EasyBlogHelper::getTable( 'Profile', 'Table');
	$blogger->load( $row->created_by );
?>
<div id="entry_<?php echo $row->id; ?>" class="blog-post article_row type-twitter prel">
	<?php if( $system->admin || $isMineBlog ) : ?>
	<div class="post-admin-menu pabs gradA">
		<span class="icon-menu"></span>
		<ul class="reset-ul float-li float-l pabs admin_menu">
			<?php if( $system->admin || ($isMineBlog && $acl->rules->delete_entry)) : ?>
			<?php if( $system->admin ) : ?>
			<li class="featured_add" <?php echo ($row->isFeatured) ? 'style="display:none;"' : '';?> >
				<a href="javascript:eblog.featured.add('post','<?php echo $row->id;?>');">
					<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_THIS'); ?>
				</a>
			</li>
			<li class="featured_remove" <?php echo ($row->isFeatured) ? '' : 'style="display:none;"';?> >
				<a href="javascript:eblog.featured.remove('post','<?php echo $row->id;?>');">
					<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_REMOVE'); ?>
				</a>
			</li>
			<?php endif; ?>
			<li class="edit"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write&blogid='.$row->id);?><?php echo ($system->config->get( 'layout_dashboardanchor' ) ) ? '#write-entry' : '';?>"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_EDIT_ENTRY'); ?></a></li>
			<li class="delete">
				<a href="javascript:eblog.blog.confirmDelete( '<?php echo $row->id;?>' , '<?php echo $currentURL;?>' );"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_DELETE_ENTRY'); ?></a>
			</li>
			<li class="unpublish">
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&controller=dashboard&from=eblog&task=toggleBlogStatus&status=0&blogId=' . $row->id );?>"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_UNPUBLISH_ENTRY'); ?></a>
			</li>
			<?php endif; ?>
		</ul>
	</div>
	<?php endif; ?>

	<div class="blog-head">
		<?php if ( $system->config->get('layout_avatar') && $showAvatar ) : ?>
		<div class="blog-avatar float-l prel">
			<i class="folded pabs"></i>
			<a href="<?php echo $blogger->getProfileLink(); ?>" class="avatar float-l">
				<img src="<?php echo $row->avatar; ?>" alt="<?php echo $row->displayName; ?>" class="avatar isBlogger" width="60" height="60" />
			</a>
		</div>
		<?php endif; ?>
		<div class="blog-head-in">
			<?php if( $row->isFeatured ) { ?>
			<div class="tag-featured"><div class="in"><?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURED'); ?></div></div>
			<?php } ?>

			<h3 id="title_<?php echo $row->id; ?>" class="blog-title<?php echo ($row->isFeatured) ? ' featured' : '';?> rip mbm">
				<?php echo EasyBlogHelper::getHelper( 'String' )->linkTweets( EasyBlogHelper::getHelper( 'String' )->url2link(  $row->text ) ); ?>
			</h2>

			<div class="blog-meta twitter mbm">
				<div class="in">
					<span class="blog-author">
						<?php echo JText::_( 'COM_EASYBLOG_TWEETED_BY' );?>
						<a href="<?php echo $blogger->getProfileLink(); ?>"><?php echo $row->displayName; ?></a>
						<?php echo EasyBlogTooltipHelper::getBloggerHTML( $row->created_by, array('my'=>'left top','at'=>'right bottom','of'=>array('traverseUsing'=>'prev')) ); ?>
						<?php echo JText::_( 'COM_EASYBLOG_ON' ); ?>
						<span><?php echo $this->formatDate( $system->config->get('layout_dateformat') , $row->created ); ?></span>
					</span>
					<span class="blog-category">
						<?php echo JText::sprintf( 'COM_EASYBLOG_IN' , EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id='.$row->category_id), $row->category ); ?>
					</span>
					<?php if( $system->config->get('main_comment') && $row->totalComments !== false ) { ?>
					&middot;
					<span class="blog-comments">
						<?php if( $system->config->get('comment_disqus') ) { ?>
							<?php echo $row->totalComments; ?>
						<?php } else { ?>
						<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry&id='.$row->id); ?>#comments">
							<?php echo $this->getNouns( 'COM_EASYBLOG_COMMENT_COUNT' , $row->totalComments , true );?>
						</a>
						<?php } ?>
					</span>
					<?php } ?>
				</div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	

	<div class="blog-content clearfix">

		<!-- joomla content plugin call -->
		<?php echo $row->event->afterDisplayTitle; ?>

		<?php /* content copyright */ ?>
		<?php if( $system->config->get( 'layout_copyrights' ) && !empty($row->copyrights) ) { ?>
		<div class="blog-copyrights mtm">
			<div class="in clearfix">
				<span class="blog-copyrights">
					<?php echo JText::_('COM_EASYBLOG_COPYRIGHTS_PREFIX') . $row->copyrights ?>
				</span>
			</div>
		</div>
		<?php } ?>

		<?php if($system->config->get('layout_showcomment', false) && EasyBlogHelper::getHelper( 'Comment')->isBuiltin()) { ?>
		<?php
			$this->set( 'row' , $row );
			echo $this->fetch( 'blog.item.comment.list.php' );
		?>
		<?php } ?>
	</div><!--end: .blog-content-->
	<div class="clear"></div>
	<div class="blog-meta-bottom fsm mtm">
		<div class="in clearfix">
		<?php if( $system->config->get( 'layout_hits' ) ): ?>
			<span class="blog-hit"><?php echo JText::sprintf( 'COM_EASYBLOG_HITS_TOTAL' , $row->hits ); ?></span>
		<?php endif; ?>
		
		<?php $this->set( 'row' , $row ); ?>
		<?php echo $this->fetch( 'blog.source' . EasyBlogHelper::getHelper( 'Sources' )->getTemplateFile( $row->source ) . '.php' ); ?>
		
		<?php if( $system->config->get( 'main_ratings_frontpage' ) ) { ?>
			<span class="blog-rating">
				<?php echo EasyBlogHelper::getHelper( 'ratings' )->getHTML( $row->id , EBLOG_RATINGS_TYPE_ENTRY , JText::_( 'COM_EASYBLOG_RATINGS_RATE_BLOG_ENTRY') , 'blog-' . $row->id . '-ratings' , $system->config->get( 'main_ratings_frontpage_locked' ) ); ?>
			</span>
		<?php } ?>
		</div>
	</div>
</div><!--end: .blog-post-->
<?php
}
?>
