<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');
?>
<div class="blog blog-news blog-noBorder ">
    <h2 id="ezblog-section"><?php echo JText::_('COM_EASYBLOG_ARCHIVE_PAGE_TITLE') ?></h2>
    <p><?php echo $archiveTitle; ?></p>
 <div id="ezblog-posts" class="archive-list reset-ul">
    <?php
	if( $data )
	{
		foreach ( $data as $row )
		{
			$isMineBlog = EasyBlogHelper::isMineBlog($row->created_by, $my->id);

			$team   = '';
		    if( isset($row->team_id) )
		    {
				$team	= ( !empty( $row->team_id )) ? '&team=' . $row->team_id : '';
		    }

            $blogger    =& EasyBlogHelper::getTable( 'Profile', 'Table');
            $blogger->load( $row->created_by );
    ?>

			<div id="entry_<?php echo $row->id; ?>" class="blog-post article_row clearfix prel post-wrapper <?php echo (!empty($team)) ? 'teamblog-post' : '' ;?>">
                <h3 class="rip blog-title">
    				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>" class="fsx fwb"><?php echo $row->title; ?></a>
                    <?php if( $row->isFeatured ) { ?><sup class="tag-featured"><?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURED'); ?></sup><?php } ?>
                </h3>
				<p><?php echo (JString::strlen($row->text) > 150) ? JString::substr(strip_tags($row->text), 0, 150) . '...' : strip_tags($row->text) ; ?></p>
                <div class="small fsm">
                    
                    <span class="post-author"><?php echo $this->formatDate( $config->get('layout_shortdateformat', '%b %d') , $row->created ); ?></span>
                    
                    <span class="blog-category"><?php echo JText::sprintf('COM_EASYBLOG_POSTED_IN_CATEGORY', EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id='.$row->category_id), $row->category); ?></span>
                
                    <?php if( $system->config->get('main_comment') && $row->totalComments !== false ) { ?>
                    <span>
					<?php if( $system->config->get('comment_disqus') ) { ?>
						<?php echo $row->totalComments; ?>
					<?php } else { ?>
						<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>#comments"><?php echo $this->getNouns( 'COM_EASYBLOG_COMMENT_COUNT' , $row->totalComments , true ); ?></a>
					<?php } ?>
					</span>
    				<?php } ?>
		            <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>" class="blog-more">
		                <span><?php echo JText::_('COM_EASYBLOG_CONTINUE_READING'); ?></span>
		            </a>
                </div>
			</div>
    <?php
    	}
    }
    else
    {
    ?>
     <div class="eblog-message info mtm"><?php echo $emptyPostMsg;?></div>
    <?php } ?>
    </div>
    <?php if ( $pagination ) : ?>
    <div class="pagination clearfix">
        <?php echo $pagination; ?>
    </div>
    <?php endif; ?>
</div>
