<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

?>
<?php if( ($blog->ispending && $system->admin ) || ((!$blog->ispending) && ($system->admin || $isMineBlog) ) ) : ?>
<div id="admin_menu_<?php echo $blog->id; ?>" class="blog-admin clearfix pbm pls">
	<ul style="display:block !important" class="reset-ul float-li small">
		<?php if($system->admin) : ?>
		<li class="featured_add" <?php echo ($isFeatured) ? 'style="display:none;"' : '';?> >
			<a href="javascript:eblog.featured.add('post','<?php echo $blog->id;?>');">
				<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_THIS'); ?>
			</a>
		</li>
		<li class="featured_remove" <?php echo ($isFeatured) ? '' : 'style="display:none;"';?> >
			<a href="javascript:eblog.featured.remove('post','<?php echo $blog->id;?>');">
				<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_REMOVE'); ?>
			</a>
		</li>
		<?php endif; ?>

		<li class="edit"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write&blogid='.$blog->id);?><?php echo ($system->config->get( 'layout_dashboardanchor' ) ) ? '#write-entry' : '';?>"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_EDIT_ENTRY'); ?></a></li>

		<?php if($system->admin || ($isMineBlog && $acl->rules->delete_entry)) : ?>
		<li class="delete">
			<a href="javascript:eblog.blog.confirmDelete( '<?php echo $blog->id;?>' , '<?php echo 'index.php?option=com_easyblog&view=latest';?>' );"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_DELETE_ENTRY'); ?></a>
		</li>
		<?php endif; ?>

		<?php if($system->admin || ($isMineBlog && $acl->rules->publish_entry)) : ?>
		<li class="unpublish">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&controller=dashboard&from=eblog&task=toggleBlogStatus&status=0&blogId=' . $blog->id );?>"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_UNPUBLISH_ENTRY'); ?></a>
		</li>
		<?php endif; ?>
	</ul>
</div>
<?php endif; ?>