<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');
?>
<script type="text/javascript">
(function($){
	$(document).ready(function(){
		eblog.dashboard.lists.init( 'pending' );
	});
})(sQuery);
</script>
<div id="dashboard-pending" class="prel stackSelectGroup">
	<div class="dashboard-head clearfix">
		<div class="page_title pending_title float-l reset fsx fwb">
			<?php if( $isReview) {
			    echo JText::_('COM_EASYBLOG_DASHBOARD_REVIEW_PAGE_HEADING');
			} else {
			    echo JText::_('COM_EASYBLOG_DASHBOARD_PENDING_PAGE_HEADING');
			} ?>
		</div>
	</div>
	
	<?php if( $isReview ) : ?>
	<div class="eblog-message warning">
		<span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_REVIEW_NOTICE'); ?></span>
	</div>
	<?php endif; ?>
	
	<?php if( ( !empty($this->acl->rules->delete_entry) && !empty($this->acl->rules->manage_pending) ) && !$isReview  ) { ?>
	<div class="ui-optbox clearfix fsm">
		<div class="entries-select float-l">
			<ul class="ui-list-select-actions reset-ul float-li clearfix">
				<li>
					<input type="checkbox" class="stackSelectAll float-l" name="toggle" id="toggle"/>
					<label for="toggle" class="float-l mls mts"><?php echo JText::_( 'COM_EASYBLOG_SELECT_ALL' );?></label>
	            </li>
				<li id="select-actions">
					<select name="pending-action" id="pending-action">
						<option value="default"><?php echo JText::_('COM_EASYBLOG_WITH_SELECTED');?></option>
						<option value="rejectBlog"><?php echo JText::_('COM_EASYBLOG_REJECT');?></option>
					</select>
					<input type="button" class="ui-button" value="<?php echo JText::_('COM_EASYBLOG_APPLY_BUTTON');?>" onclick="eblog.dashboard.action( 'pending', 'index.php?option=com_easyblog&view=dashboard&layout=pending' );"/>
				</li>
			</ul>
		</div>
	</div>
	<?php } ?>
	
	
	<form name="pending-form" id="pending-form">
		<?php if ( $entries ) : ?>
		<ul class="item_list reset-ul">
			<?php $i = 0; ?>
			<?php foreach( $entries as $entry ):
			$team   	= '';
			$teamBlog   = null;

			if( isset($entry->team_id) )
			{
			    if( !empty( $entry->team_id ) )
				{
					$team		= '&team=' . $entry->team_id;
					$teamBlog   =& EasyBlogHelper::getTable( 'TeamBlog', 'Table');
					$teamBlog->load( $entry->team_id );
				}
 			}

			?>
			<li id="eb-entry-<?php echo $entry->id; ?>">
				<div class="listing">
				<?php if( $isReview ) { ?>
					<div class="item_title mbs"><a href="javascript:void(0);" class="fsl fwb ffa"><?php echo $entry->title;?></a></div>
					<span class="ui-list-select pabs">&nbsp;</span>
				<?php } else { ?>
					<div class="item_title mbs"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write&draft_id='.$entry->id.'&approval=1');?>" class="fsl fwb ffa"><?php echo $entry->title;?></a></div>
					<span class="ui-list-select pabs"><input type="checkbox" class="stackSelect" value="<?php echo $entry->id; ?>" name="cid[]" id="cb<?php echo $i;?>" /></span>
				<?php } ?>
					
					
	            	<ul class="ui-entry-meta clearfix reset-ul float-li mts">
						<li class="ico-tags"><?php echo $this->getNouns( 'COM_EASYBLOG_TAGS_COUNT' , count( $entry->_tags ) , true ); ?></li>
						<li class="ico-category"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id=' . $entry->category_id); ?>" class="fsm"><?php echo $entry->category; ?></a></li>
	                </ul>
					<div class="clearfix mts">
						<?php if( !$isReview ) { ?>
	                    <div class="item_actions float-l" id="eblog-comment-toolbar<?php echo $entry->id; ?>">
	    					<ul class="reset-ul float-li">
	    						<?php if( $this->acl->rules->manage_pending && $this->acl->rules->add_entry ) : ?>
	    						<li><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write&draft_id='.$entry->id.'&approval=1');?>"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_PENDING_REVIEW_POST'); ?></a> </li>
	    						<?php endif; ?>
	    						<?php if( $this->acl->rules->manage_pending && $this->acl->rules->add_entry) : ?>
	    						<li><a href="javascript:eblog.blog.approve('index.php?option=com_easyblog&view=dashboard&layout=pending','<?php echo $entry->id;?>');"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_PENDING_APPROVE_POST'); ?></a></li>
	    						<?php endif; ?>
	    						<?php if( $this->acl->rules->manage_pending ) : ?>
	    						<li><a href="javascript: eblog.editor.reject( '<?php echo $entry->id; ?>' );"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_PENDING_REJECT_POST'); ?></a></li>
	    						<?php endif; ?>
	    					</ul>
	    				</div>
	    				<?php } ?>
	    				<span class="ui-inmsg mlm"></span>
						<span class="float-r"><?php echo $this->formatDate( JText::_( 'DATE_FORMAT_LC1' ) ,  $entry->created); ?></span>
					</div>

                    <div class="ui-authors ui-avatar pabs">
    				<?php if( !empty($team) ) : ?>
                        <!-- teamblog avatar -->
    			        <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=teamblog&layout=listings&id=' . $teamBlog->id); ?>" title="<?php echo $teamBlog->title; ?>"  class="isTeamBlog pabs">
    						<img src="<?php echo $teamBlog->getAvatar(); ?>" alt="<?php echo $teamBlog->title; ?>" class="avatar" width="40" height="40" />
    					</a>
                    <?php endif; ?>
    					<!-- blogger avatar -->
    			        <a href="<?php echo $entry->author->getProfileLink(); ?>" title="<?php echo $entry->author->getName(); ?>"  class="isBlogger pabs">
    						<img src="<?php echo $entry->author->getAvatar(); ?>" alt="<?php echo $entry->author->getName(); ?>" width="40" height="40" />
    					</a>
    					<?php echo EasyBlogTooltipHelper::getBloggerHTML( $entry->author->id, array('my'=>'left bottom','at'=>'left top','of'=>array('traverseUsing'=>'prev')) ); ?>
    				</div><!--end: .ui-authors-->

				</div>
			</li>
			<?php $i++; ?>
			<?php endforeach; ?>
		</ul>
			<?php if ( !empty($pagination) ) : ?>
				<div class="pagination"><?php echo $pagination->getPagesLinks(); ?></div>
			<?php endif; ?>
		<?php else: ?>
			<div class="eblog-message info">
				<?php echo JText::_('COM_EASYBLOG_DASHBOARD_ENTRIES_EMPTY'); ?>
			</div>
		<?php endif; ?>
	</form>
</div>