<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
defined('_JEXEC') or die('Restricted access');

$class = '';
if(! $system->config->get('layout_avatar'))
{
	$class = 'no-avatar';
}

$team   	= (! empty($teamId)) ? '&team=' . $teamId : '';

foreach($data as $row)
{
	$showAvatar	= isset( $showAvatar ) ? $showAvatar : true;
	$isMineBlog = EasyBlogHelper::isMineBlog($row->created_by, $system->my->id);

	$blogger	=& EasyBlogHelper::getTable( 'Profile', 'Table');
	$blogger->load( $row->created_by );

	$loadratings		= true;
	$loadsocialbutton 	= true;
	$loadtags 			= true;
	$loadfblike 		= true;
	$loadcomments		= true;

	if($system->config->get('main_password_protect', true) && !empty($row->blogpassword))
	{
		if(!EasyBlogHelper::verifyBlogPassword($row->blogpassword, $row->id))
		{
			$loadratings		= false;
			$loadsocialbutton 	= false;
			$loadtags 			= false;
			$loadfblike 		= false;
			$loadcomments		= false;
		}
	}

	if( empty( $team ) )
	{
		// if team is empty, then we cehck against the team_id from query.
		if( isset($row->team_id) )
		{
			$team	= ( !empty( $row->team_id )) ? '&team=' . $row->team_id : '';
		}
	}
?>
<div id="entry_<?php echo $row->id; ?>" class="blog-post article_row type-twitter clearfix prel <?php echo (!empty($team)) ? 'teamblog-post' : '' ;?>">
<div class="blog-post-in">

	<?php
	/**
	* ----------------------------------------------------------------------------------------------------------
	* Site Admin Control
	* ----------------------------------------------------------------------------------------------------------
	*/
	?>
	<?php if( $system->admin || $isMineBlog ) : ?>
	<div class="post-admin-menu pabs gradA">
		<span class="icon-menu"></span>
		<ul class="reset-ul float-li float-l pabs admin_menu">
			<?php if( $system->admin || ($isMineBlog && $acl->rules->delete_entry)) : ?>
			<?php if( $system->admin ) : ?>
			<li class="featured_add" <?php echo ($row->isFeatured) ? 'style="display:none;"' : '';?> >
				<a href="javascript:eblog.featured.add('post','<?php echo $row->id;?>');">
					<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_THIS'); ?>
				</a>
			</li>
			<li class="featured_remove" <?php echo ($row->isFeatured) ? '' : 'style="display:none;"';?> >
				<a href="javascript:eblog.featured.remove('post','<?php echo $row->id;?>');">
					<?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURE_REMOVE'); ?>
				</a>
			</li>
			<?php endif; ?>
			<li class="edit"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write&blogid='.$row->id);?><?php echo ($system->config->get( 'layout_dashboardanchor' ) ) ? '#write-entry' : '';?>"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_EDIT_ENTRY'); ?></a></li>
			<li class="delete">
				<a href="javascript:eblog.blog.confirmDelete( '<?php echo $row->id;?>' , '<?php echo $currentURL;?>' );"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_DELETE_ENTRY'); ?></a>
			</li>
			<li class="unpublish">
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&controller=dashboard&from=eblog&task=toggleBlogStatus&status=0&blogId=' . $row->id );?>"><?php echo Jtext::_('COM_EASYBLOG_ADMIN_UNPUBLISH_ENTRY'); ?></a>
			</li>
			<?php endif; ?>
		</ul>
	</div>
	<?php endif; ?>

	<div class="blog-content clearfix">
		<!-- the title -->
		<h3 id="title_<?php echo $row->id; ?>" class="blog-title<?php echo ($row->isFeatured) ? ' featured' : '';?> rip mbs">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>"><?php echo $row->title; ?></a>
			<?php if( $row->isFeatured ) { ?>
			<sup class="tag-featured"><?php echo Jtext::_('COM_EASYBLOG_FEATURED_FEATURED'); ?></sup>
			<?php } ?>
		</h2>

		<!-- joomla content plugin call -->
		<?php echo $row->event->afterDisplayTitle; ?>

		<!-- the content -->
		<?php echo $row->text; ?>

		<!-- joomla content plugin call -->
		<?php echo $row->event->afterDisplayContent; ?>

		<?php /* content copyright */ ?>
		<?php if( $system->config->get( 'layout_copyrights' ) && !empty($row->copyrights) ) { ?>
		<div class="blog-copyrights mtm">
			<div class="in clearfix">
				<span class="blog-copyrights">
					<?php echo JText::_('COM_EASYBLOG_COPYRIGHTS_PREFIX') . $row->copyrights ?>
				</span>
			</div>
		</div>
		<?php } ?>

		<?php
		// show Tweetmeme and Google Buzz if enabled
		if( $system->config->get('main_socialbutton_position') == 'bottom' && $loadsocialbutton)
		{
			EasyBlogHelper::showSocialButton($row , true );
		}
		?>

		<?php if( $system->config->get('main_facebook_like') && $system->config->get('main_facebook_like_layout') != 'box_count' && $loadfblike ) : ?>
		<div class="facebook-likes mtm clearfix">
			<div id="eb-fblikes" class="align<?php echo ($this->getDirection() == 'rtl') ? 'right' : 'left'; ?>">
				<?php echo $row->facebookLike; ?>
			</div>
		</div>
		<?php endif; ?>

		<?php
		/**
		* ----------------------------------------------------------------------------------------------------------
		* Comment view in post listing
		* ----------------------------------------------------------------------------------------------------------
		*/
		?>
		<?php if($system->config->get('layout_showcomment', false) && $loadcomments && EasyBlogHelper::getHelper( 'Comment')->isBuiltin()) { ?>
		<?php
			$this->set( 'row' , $row );
			$this->set( 'team' , $team );
			echo $this->fetch( 'blog.item.comment.list.php' );
		?>
		<?php } ?>

		<div class="blog-meta-bottom fsm mtm">
			<div class="blog-meta-in clearfix">
			<?php if( $system->config->get( 'layout_hits' ) ): ?>
				<span class="blog-hit"><?php echo JText::sprintf( 'COM_EASYBLOG_HITS_TOTAL' , $row->hits ); ?></span>
			<?php endif; ?>
				<span class="blog-via"><?php echo JText::_( 'COM_EASYBLOG_POSTED_VIA_EMAIL' );?></span>
			<?php if( $system->config->get('main_comment') && $row->totalComments !== false ) { ?>
				<span class="blog-comments">
					<?php if( $system->config->get( 'comment_disqus' ) ) { ?>
						<?php echo $row->totalComments; ?>
					<?php } else { ?>
					<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>#comments">
						<?php echo $this->getNouns( 'COM_EASYBLOG_COMMENT_COUNT' , $row->totalComments , true );?>
					</a>
					<?php } ?>
				</span>
			<?php } ?>
			<?php if( $row->readmore ){ ?>
				<span class="blog-more">
					<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>" class="blog-more">
						<span><?php echo JText::_('COM_EASYBLOG_CONTINUE_READING'); ?></span>
					</a>
				</span>
			<?php } ?>
			</div>
		</div>
	</div><!--end: .blog-content-->
</div><!--end: .blog-post-in-->

<div class="blog-meta">
	<div class="clearfix pal">
		<?php
		/**
		* ----------------------------------------------------------------------------------------------------------
		* Author avatar
		* ----------------------------------------------------------------------------------------------------------
		*/
		?>
		<?php if ( $system->config->get('layout_avatar') && $showAvatar ) : ?>
		<div class="blog-avatar float-l prel mrl">
			<?php
				if( isset( $row->team_id ) )
				{
					$teamBlog   =& EasyBlogHelper::getTable( 'TeamBlog', 'Table');
					$teamBlog->load( $row->team_id );
			?>
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=teamblog&layout=listings&id=' . $teamBlog->id ); ?>" class="avatar isTeamBlog float-l prel">
				<img src="<?php echo $teamBlog->getAvatar(); ?>" alt="<?php echo $teamBlog->title; ?>" class="avatar" width="38" height="38" />
			</a>
			<a href="<?php echo $blogger->getProfileLink(); ?>" class="avatar isBlogger float-l pabs">
				<img src="<?php echo $row->avatar; ?>" alt="<?php echo $row->displayName; ?>" class="avatar" width="20" height="20" />
			</a>
			<?php
				} else {
			?>
			<a href="<?php echo $blogger->getProfileLink(); ?>" class="avatar float-l">
				<img src="<?php echo $row->avatar; ?>" alt="<?php echo $row->displayName; ?>" class="avatar isBlogger" width="38" height="38" />
			</a>
			<?php } ?>
		</div>
		<?php endif; ?>
		<div class="blog-meta">
			<div>
				<div class="float-r">
					<?php if( $row->readmore ){ ?>
					<div class="blog-continue float-r">
						<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>">
							<span><?php echo JText::_('COM_EASYBLOG_CONTINUE_READING'); ?></span>
						</a>
					</div>
					<?php } ?>

					<?php if( $system->config->get('main_comment') && $row->totalComments !== false ) { ?>
					<div class="post-comments float-r mrm">
						<?php if( $system->config->get('comment_disqus') ) { ?>
							<?php echo $row->totalComments; ?>
						<?php } else { ?>
						<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$row->id); ?>#comments">
							<?php echo $this->getNouns( 'COM_EASYBLOG_COMMENT_COUNT' , $row->totalComments , true );?>
						</a>
						<?php } ?>
					</div>
					<?php } ?>
				</div>
				<?php if( $loadratings && $system->config->get( 'main_ratings_frontpage' ) ) { ?>
				<div class="blog-rating in-block">
					<?php echo EasyBlogHelper::getHelper( 'ratings' )->getHTML( $row->id , EBLOG_RATINGS_TYPE_ENTRY , JText::_( 'COM_EASYBLOG_RATINGS_RATE_BLOG_ENTRY') , 'blog-' . $row->id . '-ratings' , $system->config->get( 'main_ratings_frontpage_locked' ) ); ?>
				</div>
				<?php } ?>
			</div>
			<div class="post-author fsm mts">
				<span class="blog-author">
					<?php echo JText::_( 'COM_EASYBLOG_POSTED_BY' );?>
					<a href="<?php echo $blogger->getProfileLink(); ?>"><?php echo $row->displayName; ?></a>
					<?php echo EasyBlogTooltipHelper::getBloggerHTML( $row->created_by, array('my'=>'left top','at'=>'right bottom','of'=>array('traverseUsing'=>'prev')) ); ?>
					<?php echo JText::_( 'COM_EASYBLOG_ON' ); ?>
					<span><?php echo $this->formatDate( $system->config->get('layout_dateformat') , $row->created ); ?></span>
					<span class="blog-category">
						<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id='.$row->category_id); ?>"><?php echo $row->category; ?></a>
					</span>
				</span>
			</div>
		</div>
	</div>
</div>
</div><!--end: .blog-post-->
<?php
}//end foreach
?>
