<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *  
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( EBLOG_HELPERS . DS . 'helper.php' );

class EasyBlogVideosHelper
{
	private $patterns	= array(
									'youtube.com'		=> 'youtube',
									'youtu.be'			=> 'youtube',
									'vimeo.com'			=> 'vimeo',
									'yahoo.com'			=> 'yahoo',
									'metacafe.com'		=> 'metacafe',
									'google.com'		=> 'google',
									'mtv.com'			=> 'mtv',
									'liveleak.com'		=> 'liveleak',
									'revver.com'		=> 'revver',
									'dailymotion.com'	=> 'dailymotion',
									'nicovideo.jp'		=> 'nicovideo'
								);
	
	public function strip( $content )
	{
	
		// In case Joomla tries to entity the contents, we need to replace accordingly.
		$content	= str_ireplace( '&quot;' , '"' , $content );
		
		$pattern	= array('/\{video:.*?\}/',
							'/\{"video":.*?\}/'
							);
							
		$replace    = array('','');
		

		return preg_replace( $pattern , $replace , $content );
	}
	
	public function processVideos( $content )
	{
		// @since 2.0.3515, video:"url" has been changed to "video":"url"
		$pattern	= '/\{"video":.*?\}/i';
		
		// In case Joomla tries to entity the contents, we need to replace accordingly.
		$content	= str_ireplace( '&quot;' , '"' , $content );
		
		preg_match_all( $pattern , $content , $matches );
		$videos		= $matches[0];

		// @since 2.0.3515 Legacy support for older codes video:"url"
		if( empty( $videos ) )
		{
			$pattern	= '/\{video:.*?\}/i';
			preg_match_all( $pattern , $content , $matches );
			$videos		= $matches[0];
		}
		
		if( !empty( $videos ) )
		{
			$json	= new Services_JSON();

			foreach( $videos as $video )
			{
				$data	= $json->decode( $video );

				preg_match( '/http\:\/\/(.*)\//i' , $data->video , $matches );
				
				if( !$matches )
				{
					continue;
				}
				
				$url	= $matches[0];
				$url	= parse_url( $url );
				$url	= explode( '.' , $url[ 'host' ] );
				
				// Last two parts will always be the domain name.
				$url	= $url[ count( $url ) - 2 ] . '.' . $url[ count( $url ) - 1 ];
				
				if( !empty( $url ) && array_key_exists( $url , $this->patterns ) )
				{
					$provider	= JString::strtolower( $this->patterns[ $url ] );
					$path		= EBLOG_CLASSES . DS . 'videos' . DS . $provider . '.php';

					require_once( $path );
					
					$class	= 'EasyBlogVideo' . ucfirst( $this->patterns[ $url ] );
					
					if( class_exists( $class ) )
					{
						$object		= new $class();
						$html		= $object->getEmbedHTML( $data->video , $data->width , $data->height );

						$content	= str_ireplace( $video , $html , $content );
					}
				}
			}
		}
// 		exit;
		return $content;
	}
}