<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( EBLOG_HELPERS . DS .'helper.php' );

class EasyBlogTweetMeme
{
	public static function getHTML( $row )
	{
		$config	= EasyBlogHelper::getConfig();

		if( !$config->get('main_tweetmeme') )
		{
			return '';
		}

		$url		= $config->get('main_tweetmeme_url');
		$style		= $config->get('main_tweetmeme_style');
		$source		= $config->get('main_tweetmeme_rtsource');

		$teamIdLink = '';
		if( isset( $row->team ) )
			$teamIdLink = '&team=' . $row->team;

		$html	= "<script type=\"text/javascript\">
					tweetmeme_service ='$url';
					tweetmeme_style = '$style';
					tweetmeme_url	= '" . EasyBlogRouter::getRoutedURL('index.php?option=com_easyblog&view=entry&id=' . $row->id . $teamIdLink, false, true) . "';
					tweetme_title='".addslashes($row->title)."';";

		if(!empty($source))
		{
			$html .= "tweetmeme_source='".addslashes($source)."';";
		}

		$html	.= "</script>";
		$html	.= '<div class="social-button tweetmeme"><script type="text/javascript" src="http://tweetmeme.com/i/scripts/button.js"></script></div>';
		return $html;
	}
}
