<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once(JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_smms' . DS . 'tables' . DS . 'smmsextension.php');

class DBInstaller {
	function create_database($db, $status) {
		$status = DBInstaller::install_address_table($db, $status);
		$status = DBInstaller::install_categories_table($db, $status);
		$status = DBInstaller::install_defaults_table($db, $status);
		$status = DBInstaller::install_description_table($db, $status);
		$status = DBInstaller::install_feeds_table($db, $status);
		$status = DBInstaller::install_keywords_table($db, $status);
		$status = DBInstaller::install_miscmeta_table($db, $status);
		$status = DBInstaller::install_modules_table($db, $status);
		$status = DBInstaller::install_replace_table($db, $status);
		$status = DBInstaller::install_settings_table($db, $status);
		$status = DBInstaller::install_stopwords_table($db, $status);
		$status = DBInstaller::install_title_table($db, $status);
		return $status;
	}

	function fill_database($db, $status) {
		$status = DBInstaller::fill_categories_table($db, $status);
		$status = DBInstaller::fill_settings_table($db, $status);
		$status = DBInstaller::fill_stopwords_table($db, $status);
		return $status;
	}

	function install_address_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_address';
		$create_address_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_address') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('address') . ' varchar(255) NOT NULL,
			' . $db->nameQuote('categoryid') . ' int(11) NOT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . '),
			UNIQUE KEY ' . $db->nameQuote('address') . ' (' . $db->nameQuote('address') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_address_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';		
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_categories_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_categories';
		$create_categories_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_categories') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('enabled') . ' tinyint(1) NOT NULL,
			' . $db->nameQuote('name') . ' varchar(150) NOT NULL,
			' . $db->nameQuote('category') . ' varchar(255) NOT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . '),
			KEY ' . $db->nameQuote('name') . ' (' . $db->nameQuote('name') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_categories_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';		
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	
	function install_defaults_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_defaults';
		$create_defaults_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_defaults') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('module_id') . ' int(11) NOT NULL,
			' . $db->nameQuote('fieldname') . ' varchar(255) NOT NULL,
			' . $db->nameQuote('fieldvalue') . ' text,
			' . $db->nameQuote('formfield') . ' text,
			PRIMARY KEY (' . $db->nameQuote('id') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_defaults_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';		
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_description_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_description';
		$create_description_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_description') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('site_id') . ' int(11) unsigned NOT NULL,
			' . $db->nameQuote('custom_description') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('description') . ' text,
			PRIMARY KEY (' . $db->nameQuote('id') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_description_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';		
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_feeds_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_feeds';
		$create_feeds_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_feeds') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('site_id') . ' int(11) unsigned NOT NULL,
			' . $db->nameQuote('custom_atom') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('atom') . ' text,
			' . $db->nameQuote('atom_title') . ' varchar(255) DEFAULT NULL,
			' . $db->nameQuote('custom_rss') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('rss') . ' text,
			' . $db->nameQuote('rss_title') . ' varchar(255) DEFAULT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_feeds_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_keywords_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_keywords';
		$create_keywords_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_keywords') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('site_id') . ' int(11) unsigned NOT NULL,
			' . $db->nameQuote('custom_keywords') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('keywords') . ' text,
			PRIMARY KEY (' . $db->nameQuote('id') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_keywords_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_miscmeta_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_miscmeta';
		$create_miscmeta_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_miscmeta') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('site_id') . ' int(11) unsigned NOT NULL,
			' . $db->nameQuote('custom_robots') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('robots') . ' varchar(30) DEFAULT NULL,
			' . $db->nameQuote('custom_language') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('language') . ' varchar(30) DEFAULT NULL,
			' . $db->nameQuote('custom_contenttype') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('contenttype') . ' varchar(255) DEFAULT NULL,
			' . $db->nameQuote('custom_icon') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('icon') . ' varchar(255) DEFAULT NULL,
			' . $db->nameQuote('custom_copyright') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('copyright') . ' varchar(255) DEFAULT NULL,
			' . $db->nameQuote('custom_author') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('author') . ' varchar(255) DEFAULT NULL,
			' . $db->nameQuote('custom_generator') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('generator') . ' varchar(255) DEFAULT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_miscmeta_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_modules_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_modules';
		$create_modules_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_modules') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('enabled') . ' tinyint(1) NOT NULL,
			' . $db->nameQuote('name') . ' varchar(150) NOT NULL,
			' . $db->nameQuote('category') . ' varchar(20) NOT NULL,
			' . $db->nameQuote('databasename') . ' varchar(150) NOT NULL,
			' . $db->nameQuote('pregmatch') . ' text NOT NULL,
			' . $db->nameQuote('pregmatch2') . ' text,
			' . $db->nameQuote('html') . ' text NOT NULL,
			' . $db->nameQuote('formfield') . ' text NOT NULL,
			' . $db->nameQuote('databasefield') . ' varchar(255) NOT NULL,
			' . $db->nameQuote('sqlselect') . ' text NOT NULL,
			' . $db->nameQuote('sqljoin') . ' text NOT NULL,
			' . $db->nameQuote('sqlupdatewithvalue') . ' text NOT NULL,
			' . $db->nameQuote('sqlupdatenovalue') . ' text NOT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . '),
			KEY ' . $db->nameQuote('name') . ' (' . $db->nameQuote('name') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_modules_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_replace_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_replace';
		$create_replace_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_replace') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('replacestring') . ' varchar(255) NOT NULL,
			' . $db->nameQuote('replace_enabled') . ' tinyint(4) NOT NULL DEFAULT ' . $db->Quote('0') . ',
			' . $db->nameQuote('replacewithstring') . ' varchar(255) DEFAULT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . '),
			UNIQUE KEY ' . $db->nameQuote('replace') . ' (' . $db->nameQuote('replacestring') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_replace_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_settings_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_settings';
		$create_settings_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_settings') . ' (
			' . $db->nameQuote('id') . ' int(10) unsigned NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('key') . ' varchar(255) NOT NULL,
			' . $db->nameQuote('value') . ' text NOT NULL,
			' . $db->nameQuote('field_type') . ' varchar(50) NOT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . '),
			UNIQUE KEY ' . $db->nameQuote('key') . ' (' . $db->nameQuote('key') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_settings_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function install_stopwords_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_stopwords';
		$create_stopwords_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_stopwords') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('word') . ' varchar(255) NOT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . '),
			UNIQUE KEY ' . $db->nameQuote('word') . ' (' . $db->nameQuote('word') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_stopwords_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}

	function install_title_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_title';
		$create_title_table_sql =
			'CREATE TABLE IF NOT EXISTS ' . $db->nameQuote('#__smms_title') . ' (
			' . $db->nameQuote('id') . ' int(11) NOT NULL AUTO_INCREMENT,
			' . $db->nameQuote('site_id') . ' int(11) unsigned NOT NULL,
			' . $db->nameQuote('custom_title') . ' tinyint(4) NOT NULL,
			' . $db->nameQuote('title') . ' varchar(255) DEFAULT NULL,
			PRIMARY KEY (' . $db->nameQuote('id') . ')
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;';
		$db->setQuery($create_title_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		}
		return $status;
	}
	
	function fill_categories_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_categories';
		
		$fetchquery = "SELECT `name`, `option` FROM jos_components WHERE `iscore` = 0 AND `option` <> '' AND `enabled` = 1 AND `option` <> 'com_content' AND `parent` = 0 ORDER BY `name`";
		$db->setQuery($fetchquery);
		$rows = $db->loadAssocList();

		$sqladd = '';
		
		foreach ($rows as $row) {
			$sqladd .= ', (0, \'' . $row['name'] . '\', \'' . $row['option'] . '\')';	
		}
		
		$fill_categories_table_sql =
			"INSERT IGNORE INTO `#__smms_categories` (`enabled`, `name`, `category`) VALUES
				(1, 'Content Articles', 'com_content')";
		
		if ($sqladd != '')
			$fill_categories_table_sql .= $sqladd;

		$fill_categories_table_sql .= ';';
		$db->setQuery($fill_categories_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Filled') . '</p>';		
		}
		return $status;
	}
	
	function fill_settings_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_settings';
		$fill_settings_table_sql =
			'INSERT INTO ' . $db->nameQuote('#__smms_settings') . ' (' . $db->nameQuote('id') . ', ' . $db->nameQuote('key') . ', ' . $db->nameQuote('value') . ', ' . $db->nameQuote('field_type') . ') VALUES
			(1,  ' . $db->Quote('core_version') . ',  ' . $db->Quote('1.5.4') . ',  ' . $db->Quote('') . '),
			(2,  ' . $db->Quote('core_productCodename') . ',  ' . $db->Quote('Dragonbane') . ',  ' . $db->Quote('') . '),
			(3,  ' . $db->Quote('core_releaseDate') . ',  ' . $db->Quote('2010-01-10') . ',  ' . $db->Quote('') . '),
			(4,  ' . $db->Quote('core_limitedinterface') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(5,  ' . $db->Quote('core_enablecanonicalization') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(6,  ' . $db->Quote('core_canonicalizationhost') . ',  ' . $db->Quote('www.myhostname.com.au') . ',  ' . $db->Quote('') . '),
			(7,  ' . $db->Quote('core_canonicalizationforcessl') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(8,  ' . $db->Quote('core_sh404sefurls') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(9,  ' . $db->Quote('core_removelanguage') . ',  ' . $db->Quote('1') . ',  ' . $db->Quote('') . '),
			(10,  ' . $db->Quote('core_removeitemid') . ',  ' . $db->Quote('1') . ',  ' . $db->Quote('') . '),
			(11,  ' . $db->Quote('core_removeurlvariables') . ',  ' . $db->Quote('path[docroot]|a|referer|q') . ',  ' . $db->Quote('{INPUT}') . '),
			(12,  ' . $db->Quote('module_enableurls') . ',  ' . $db->Quote('1') . ',  ' . $db->Quote('') . '),
			(13,  ' . $db->Quote('module_enablecategories') . ',  ' . $db->Quote('1') . ',  ' . $db->Quote('') . '),
			(14,  ' . $db->Quote('module_enablefindandreplace') . ',  ' . $db->Quote('1') . ',  ' . $db->Quote('') . '),
			(15,  ' . $db->Quote('core_stopcollectingurls') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(16,  ' . $db->Quote('google_senable') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(17,  ' . $db->Quote('google_sverificationid') . ',  ' . $db->Quote('') . ',  ' . $db->Quote('{INPUT}') . '),
			(18,  ' . $db->Quote('google_aenable') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(19,  ' . $db->Quote('google_averificationid') . ',  ' . $db->Quote('') . ',  ' . $db->Quote('{INPUT}') . '),
			(20,  ' . $db->Quote('yahoo_enable') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(21,  ' . $db->Quote('yahoo_verificationid') . ',  ' . $db->Quote('') . ',  ' . $db->Quote('{INPUT}') . '),
			(22,  ' . $db->Quote('bing_enable') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('') . '),
			(23,  ' . $db->Quote('bing_verificationid') . ',  ' . $db->Quote('') . ',  ' . $db->Quote('{INPUT}') . '),
			(24,  ' . $db->Quote('uninstallation_keepdatabase') . ',  ' . $db->Quote('1') . ',  ' . $db->Quote('{INPUT}') . '),
			(25,  ' . $db->Quote('uninstallation_renamedatabase') . ',  ' . $db->Quote('1') . ',  ' . $db->Quote('{INPUT}') . '),
			(26,  ' . $db->Quote('uninstallation_onlykeepsettings') . ',  ' . $db->Quote('0') . ',  ' . $db->Quote('{INPUT}') . ')
			;';
		$db->setQuery($fill_settings_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Filled') . '</p>';		
		}
		return $status;
	}

	function fill_stopwords_table($db, $status) {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_stopwords';
		$fill_stopwords_table_sql =
			'INSERT INTO ' . $db->nameQuote('#__smms_stopwords') . ' (' . $db->nameQuote('id') . ', ' . $db->nameQuote('word') . ') VALUES
			(1,  ' . $db->Quote('a') . '),
			(2,  ' . $db->Quote('a\'s') . '),
			(3,  ' . $db->Quote('able') . '),
			(4,  ' . $db->Quote('about') . '),
			(5,  ' . $db->Quote('above') . '),
			(6,  ' . $db->Quote('abroad') . '),
			(7,  ' . $db->Quote('according') . '),
			(8,  ' . $db->Quote('accordingly') . '),
			(9,  ' . $db->Quote('account') . '),
			(10,  ' . $db->Quote('across') . '),
			(11,  ' . $db->Quote('act') . '),
			(12,  ' . $db->Quote('actually') . '),
			(13,  ' . $db->Quote('add') . '),
			(14,  ' . $db->Quote('adj') . '),
			(15,  ' . $db->Quote('afraid') . '),
			(16,  ' . $db->Quote('after') . '),
			(17,  ' . $db->Quote('afterwards') . '),
			(18,  ' . $db->Quote('again') . '),
			(19,  ' . $db->Quote('against') . '),
			(20,  ' . $db->Quote('age') . '),
			(21,  ' . $db->Quote('ago') . '),
			(22,  ' . $db->Quote('agree') . '),
			(23,  ' . $db->Quote('ahead') . '),
			(24,  ' . $db->Quote('ain\'t') . '),
			(25,  ' . $db->Quote('all') . '),
			(26,  ' . $db->Quote('allow') . '),
			(27,  ' . $db->Quote('allows') . '),
			(28,  ' . $db->Quote('almost') . '),
			(29,  ' . $db->Quote('alone') . '),
			(30,  ' . $db->Quote('along') . '),
			(31,  ' . $db->Quote('alongside') . '),
			(32,  ' . $db->Quote('already') . '),
			(33,  ' . $db->Quote('also') . '),
			(34,  ' . $db->Quote('although') . '),
			(35,  ' . $db->Quote('always') . '),
			(36,  ' . $db->Quote('am') . '),
			(37,  ' . $db->Quote('amid') . '),
			(38,  ' . $db->Quote('amidst') . '),
			(39,  ' . $db->Quote('among') . '),
			(40,  ' . $db->Quote('amongst') . '),
			(41,  ' . $db->Quote('amount') . '),
			(42,  ' . $db->Quote('an') . '),
			(43,  ' . $db->Quote('and') . '),
			(44,  ' . $db->Quote('anger') . '),
			(45,  ' . $db->Quote('angry') . '),
			(46,  ' . $db->Quote('animal') . '),
			(47,  ' . $db->Quote('another') . '),
			(48,  ' . $db->Quote('answer') . '),
			(49,  ' . $db->Quote('any') . '),
			(50,  ' . $db->Quote('anybody') . '),
			(51,  ' . $db->Quote('anyhow') . '),
			(52,  ' . $db->Quote('anyone') . '),
			(53,  ' . $db->Quote('anything') . '),
			(54,  ' . $db->Quote('anyway') . '),
			(55,  ' . $db->Quote('anyways') . '),
			(56,  ' . $db->Quote('anywhere') . '),
			(57,  ' . $db->Quote('apart') . '),
			(58,  ' . $db->Quote('appear') . '),
			(59,  ' . $db->Quote('apple') . '),
			(60,  ' . $db->Quote('appreciate') . '),
			(61,  ' . $db->Quote('appropriate') . '),
			(62,  ' . $db->Quote('are') . '),
			(63,  ' . $db->Quote('area') . '),
			(64,  ' . $db->Quote('areas') . '),
			(65,  ' . $db->Quote('aren\'t') . '),
			(66,  ' . $db->Quote('arm') . '),
			(67,  ' . $db->Quote('arms') . '),
			(68,  ' . $db->Quote('around') . '),
			(69,  ' . $db->Quote('arrive') . '),
			(70,  ' . $db->Quote('as') . '),
			(71,  ' . $db->Quote('aside') . '),
			(72,  ' . $db->Quote('ask') . '),
			(73,  ' . $db->Quote('asked') . '),
			(74,  ' . $db->Quote('asking') . '),
			(75,  ' . $db->Quote('asks') . '),
			(76,  ' . $db->Quote('associated') . '),
			(77,  ' . $db->Quote('at') . '),
			(78,  ' . $db->Quote('attempt') . '),
			(79,  ' . $db->Quote('aunt') . '),
			(80,  ' . $db->Quote('available') . '),
			(81,  ' . $db->Quote('away') . '),
			(82,  ' . $db->Quote('awfully') . '),
			(83,  ' . $db->Quote('b') . '),
			(84,  ' . $db->Quote('back') . '),
			(85,  ' . $db->Quote('backed') . '),
			(86,  ' . $db->Quote('backing') . '),
			(87,  ' . $db->Quote('backs') . '),
			(88,  ' . $db->Quote('backward') . '),
			(89,  ' . $db->Quote('backwards') . '),
			(90,  ' . $db->Quote('bad') . '),
			(91,  ' . $db->Quote('bag') . '),
			(92,  ' . $db->Quote('bay') . '),
			(93,  ' . $db->Quote('be') . '),
			(94,  ' . $db->Quote('became') . '),
			(95,  ' . $db->Quote('because') . '),
			(96,  ' . $db->Quote('become') . '),
			(97,  ' . $db->Quote('becomes') . '),
			(98,  ' . $db->Quote('becoming') . '),
			(99,  ' . $db->Quote('been') . '),
			(100,  ' . $db->Quote('before') . '),
			(101,  ' . $db->Quote('beforehand') . '),
			(102,  ' . $db->Quote('began') . '),
			(103,  ' . $db->Quote('begin') . '),
			(104,  ' . $db->Quote('behind') . '),
			(105,  ' . $db->Quote('being') . '),
			(106,  ' . $db->Quote('beings') . '),
			(107,  ' . $db->Quote('believe') . '),
			(108,  ' . $db->Quote('bell') . '),
			(109,  ' . $db->Quote('belong') . '),
			(110,  ' . $db->Quote('below') . '),
			(111,  ' . $db->Quote('beside') . '),
			(112,  ' . $db->Quote('besides') . '),
			(113,  ' . $db->Quote('best') . '),
			(114,  ' . $db->Quote('better') . '),
			(115,  ' . $db->Quote('between') . '),
			(116,  ' . $db->Quote('beyond') . '),
			(117,  ' . $db->Quote('big') . '),
			(118,  ' . $db->Quote('body') . '),
			(119,  ' . $db->Quote('bone') . '),
			(120,  ' . $db->Quote('born') . '),
			(121,  ' . $db->Quote('borrow') . '),
			(122,  ' . $db->Quote('both') . '),
			(123,  ' . $db->Quote('bottom') . '),
			(124,  ' . $db->Quote('box') . '),
			(125,  ' . $db->Quote('boy') . '),
			(126,  ' . $db->Quote('break') . '),
			(127,  ' . $db->Quote('brief') . '),
			(128,  ' . $db->Quote('bring') . '),
			(129,  ' . $db->Quote('brought') . '),
			(130,  ' . $db->Quote('bug') . '),
			(131,  ' . $db->Quote('built') . '),
			(132,  ' . $db->Quote('busy') . '),
			(133,  ' . $db->Quote('but') . '),
			(134,  ' . $db->Quote('buy') . '),
			(135,  ' . $db->Quote('by') . '),
			(136,  ' . $db->Quote('c') . '),
			(137,  ' . $db->Quote('c\'mon') . '),
			(138,  ' . $db->Quote('c\'s') . '),
			(139,  ' . $db->Quote('call') . '),
			(140,  ' . $db->Quote('came') . '),
			(141,  ' . $db->Quote('can') . '),
			(142,  ' . $db->Quote('can\'t') . '),
			(143,  ' . $db->Quote('cannot') . '),
			(144,  ' . $db->Quote('cant') . '),
			(145,  ' . $db->Quote('caption') . '),
			(146,  ' . $db->Quote('case') . '),
			(147,  ' . $db->Quote('cases') . '),
			(148,  ' . $db->Quote('cause') . '),
			(149,  ' . $db->Quote('causes') . '),
			(150,  ' . $db->Quote('certain') . '),
			(151,  ' . $db->Quote('certainly') . '),
			(152,  ' . $db->Quote('change') . '),
			(153,  ' . $db->Quote('changes') . '),
			(154,  ' . $db->Quote('choose') . '),
			(155,  ' . $db->Quote('clear') . '),
			(156,  ' . $db->Quote('clearly') . '),
			(157,  ' . $db->Quote('close') . '),
			(158,  ' . $db->Quote('co') . '),
			(159,  ' . $db->Quote('co.') . '),
			(160,  ' . $db->Quote('com') . '),
			(161,  ' . $db->Quote('come') . '),
			(162,  ' . $db->Quote('comes') . '),
			(163,  ' . $db->Quote('concerning') . '),
			(164,  ' . $db->Quote('consequently') . '),
			(165,  ' . $db->Quote('consider') . '),
			(166,  ' . $db->Quote('considerable') . '),
			(167,  ' . $db->Quote('considering') . '),
			(168,  ' . $db->Quote('contain') . '),
			(169,  ' . $db->Quote('containing') . '),
			(170,  ' . $db->Quote('contains') . '),
			(171,  ' . $db->Quote('continue') . '),
			(172,  ' . $db->Quote('corresponding') . '),
			(173,  ' . $db->Quote('could') . '),
			(174,  ' . $db->Quote('couldn\'t') . '),
			(175,  ' . $db->Quote('course') . '),
			(176,  ' . $db->Quote('cry') . '),
			(177,  ' . $db->Quote('currently') . '),
			(178,  ' . $db->Quote('cut') . '),
			(179,  ' . $db->Quote('d') . '),
			(180,  ' . $db->Quote('dare') . '),
			(181,  ' . $db->Quote('daren\'t') . '),
			(182,  ' . $db->Quote('dark') . '),
			(183,  ' . $db->Quote('deal') . '),
			(184,  ' . $db->Quote('dear') . '),
			(185,  ' . $db->Quote('decide') . '),
			(186,  ' . $db->Quote('deep') . '),
			(187,  ' . $db->Quote('definitely') . '),
			(188,  ' . $db->Quote('described') . '),
			(189,  ' . $db->Quote('despite') . '),
			(190,  ' . $db->Quote('did') . '),
			(191,  ' . $db->Quote('didn\'t') . '),
			(192,  ' . $db->Quote('die') . '),
			(193,  ' . $db->Quote('differ') . '),
			(194,  ' . $db->Quote('different') . '),
			(195,  ' . $db->Quote('differently') . '),
			(196,  ' . $db->Quote('directly') . '),
			(197,  ' . $db->Quote('do') . '),
			(198,  ' . $db->Quote('does') . '),
			(199,  ' . $db->Quote('doesn\'t') . '),
			(200,  ' . $db->Quote('dog') . '),
			(201,  ' . $db->Quote('doing') . '),
			(202,  ' . $db->Quote('don\'t') . '),
			(203,  ' . $db->Quote('done') . '),
			(204,  ' . $db->Quote('doubt') . '),
			(205,  ' . $db->Quote('down') . '),
			(206,  ' . $db->Quote('downed') . '),
			(207,  ' . $db->Quote('downing') . '),
			(208,  ' . $db->Quote('downs') . '),
			(209,  ' . $db->Quote('downwards') . '),
			(210,  ' . $db->Quote('during') . '),
			(211,  ' . $db->Quote('e') . '),
			(212,  ' . $db->Quote('each') . '),
			(213,  ' . $db->Quote('ear') . '),
			(214,  ' . $db->Quote('early') . '),
			(215,  ' . $db->Quote('eat') . '),
			(216,  ' . $db->Quote('edu') . '),
			(217,  ' . $db->Quote('effort') . '),
			(218,  ' . $db->Quote('eg') . '),
			(219,  ' . $db->Quote('eight') . '),
			(220,  ' . $db->Quote('eighty') . '),
			(221,  ' . $db->Quote('either') . '),
			(222,  ' . $db->Quote('else') . '),
			(223,  ' . $db->Quote('elsewhere') . '),
			(224,  ' . $db->Quote('end') . '),
			(225,  ' . $db->Quote('ended') . '),
			(226,  ' . $db->Quote('ending') . '),
			(227,  ' . $db->Quote('ends') . '),
			(228,  ' . $db->Quote('enjoy') . '),
			(229,  ' . $db->Quote('enough') . '),
			(230,  ' . $db->Quote('enter') . '),
			(231,  ' . $db->Quote('entirely') . '),
			(232,  ' . $db->Quote('especially') . '),
			(233,  ' . $db->Quote('et') . '),
			(234,  ' . $db->Quote('etc') . '),
			(235,  ' . $db->Quote('even') . '),
			(236,  ' . $db->Quote('evenly') . '),
			(237,  ' . $db->Quote('ever') . '),
			(238,  ' . $db->Quote('evermore') . '),
			(239,  ' . $db->Quote('every') . '),
			(240,  ' . $db->Quote('everybody') . '),
			(241,  ' . $db->Quote('everyone') . '),
			(242,  ' . $db->Quote('everything') . '),
			(243,  ' . $db->Quote('everywhere') . '),
			(244,  ' . $db->Quote('ex') . '),
			(245,  ' . $db->Quote('exactly') . '),
			(246,  ' . $db->Quote('example') . '),
			(247,  ' . $db->Quote('except') . '),
			(248,  ' . $db->Quote('expect') . '),
			(249,  ' . $db->Quote('explain') . '),
			(250,  ' . $db->Quote('f') . '),
			(251,  ' . $db->Quote('face') . '),
			(252,  ' . $db->Quote('faces') . '),
			(253,  ' . $db->Quote('fact') . '),
			(254,  ' . $db->Quote('facts') . '),
			(255,  ' . $db->Quote('fail') . '),
			(256,  ' . $db->Quote('fairly') . '),
			(257,  ' . $db->Quote('fall') . '),
			(258,  ' . $db->Quote('far') . '),
			(259,  ' . $db->Quote('farther') . '),
			(260,  ' . $db->Quote('fat') . '),
			(261,  ' . $db->Quote('favor') . '),
			(262,  ' . $db->Quote('fear') . '),
			(263,  ' . $db->Quote('feel') . '),
			(264,  ' . $db->Quote('feet') . '),
			(265,  ' . $db->Quote('fell') . '),
			(266,  ' . $db->Quote('felt') . '),
			(267,  ' . $db->Quote('few') . '),
			(268,  ' . $db->Quote('fewer') . '),
			(269,  ' . $db->Quote('fifth') . '),
			(270,  ' . $db->Quote('fill') . '),
			(271,  ' . $db->Quote('find') . '),
			(272,  ' . $db->Quote('finds') . '),
			(273,  ' . $db->Quote('first') . '),
			(274,  ' . $db->Quote('fit') . '),
			(275,  ' . $db->Quote('five') . '),
			(276,  ' . $db->Quote('fly') . '),
			(277,  ' . $db->Quote('follow') . '),
			(278,  ' . $db->Quote('followed') . '),
			(279,  ' . $db->Quote('following') . '),
			(280,  ' . $db->Quote('follows') . '),
			(281,  ' . $db->Quote('for') . '),
			(282,  ' . $db->Quote('forever') . '),
			(283,  ' . $db->Quote('forget') . '),
			(284,  ' . $db->Quote('former') . '),
			(285,  ' . $db->Quote('formerly') . '),
			(286,  ' . $db->Quote('forth') . '),
			(287,  ' . $db->Quote('forward') . '),
			(288,  ' . $db->Quote('found') . '),
			(289,  ' . $db->Quote('four') . '),
			(290,  ' . $db->Quote('from') . '),
			(291,  ' . $db->Quote('front') . '),
			(292,  ' . $db->Quote('full') . '),
			(293,  ' . $db->Quote('fully') . '),
			(294,  ' . $db->Quote('function') . '),
			(295,  ' . $db->Quote('further') . '),
			(296,  ' . $db->Quote('furthered') . '),
			(297,  ' . $db->Quote('furthering') . '),
			(298,  ' . $db->Quote('furthermore') . '),
			(299,  ' . $db->Quote('furthers') . '),
			(300,  ' . $db->Quote('g') . '),
			(301,  ' . $db->Quote('gave') . '),
			(302,  ' . $db->Quote('general') . '),
			(303,  ' . $db->Quote('generally') . '),
			(304,  ' . $db->Quote('get') . '),
			(305,  ' . $db->Quote('gets') . '),
			(306,  ' . $db->Quote('getting') . '),
			(307,  ' . $db->Quote('give') . '),
			(308,  ' . $db->Quote('given') . '),
			(309,  ' . $db->Quote('gives') . '),
			(310,  ' . $db->Quote('go') . '),
			(311,  ' . $db->Quote('goes') . '),
			(312,  ' . $db->Quote('going') . '),
			(313,  ' . $db->Quote('gone') . '),
			(314,  ' . $db->Quote('good') . '),
			(315,  ' . $db->Quote('goods') . '),
			(316,  ' . $db->Quote('got') . '),
			(317,  ' . $db->Quote('gotten') . '),
			(318,  ' . $db->Quote('gray') . '),
			(319,  ' . $db->Quote('great') . '),
			(320,  ' . $db->Quote('greater') . '),
			(321,  ' . $db->Quote('greatest') . '),
			(322,  ' . $db->Quote('green') . '),
			(323,  ' . $db->Quote('greetings') . '),
			(324,  ' . $db->Quote('grew') . '),
			(325,  ' . $db->Quote('group') . '),
			(326,  ' . $db->Quote('grouped') . '),
			(327,  ' . $db->Quote('grouping') . '),
			(328,  ' . $db->Quote('groups') . '),
			(329,  ' . $db->Quote('grow') . '),
			(330,  ' . $db->Quote('guess') . '),
			(331,  ' . $db->Quote('h') . '),
			(332,  ' . $db->Quote('had') . '),
			(333,  ' . $db->Quote('hadn\'t') . '),
			(334,  ' . $db->Quote('half') . '),
			(335,  ' . $db->Quote('hang') . '),
			(336,  ' . $db->Quote('happen') . '),
			(337,  ' . $db->Quote('happens') . '),
			(338,  ' . $db->Quote('hardly') . '),
			(339,  ' . $db->Quote('has') . '),
			(340,  ' . $db->Quote('hasn\'t') . '),
			(341,  ' . $db->Quote('hat') . '),
			(342,  ' . $db->Quote('have') . '),
			(343,  ' . $db->Quote('haven\'t') . '),
			(344,  ' . $db->Quote('having') . '),
			(345,  ' . $db->Quote('he') . '),
			(346,  ' . $db->Quote('he\'d') . '),
			(347,  ' . $db->Quote('he\'ll') . '),
			(348,  ' . $db->Quote('he\'s') . '),
			(349,  ' . $db->Quote('hear') . '),
			(350,  ' . $db->Quote('heard') . '),
			(351,  ' . $db->Quote('held') . '),
			(352,  ' . $db->Quote('hello') . '),
			(353,  ' . $db->Quote('help') . '),
			(354,  ' . $db->Quote('hence') . '),
			(355,  ' . $db->Quote('her') . '),
			(356,  ' . $db->Quote('here') . '),
			(357,  ' . $db->Quote('here\'s') . '),
			(358,  ' . $db->Quote('hereafter') . '),
			(359,  ' . $db->Quote('hereby') . '),
			(360,  ' . $db->Quote('herein') . '),
			(361,  ' . $db->Quote('hereupon') . '),
			(362,  ' . $db->Quote('hers') . '),
			(363,  ' . $db->Quote('herself') . '),
			(364,  ' . $db->Quote('hi') . '),
			(365,  ' . $db->Quote('high') . '),
			(366,  ' . $db->Quote('higher') . '),
			(367,  ' . $db->Quote('highest') . '),
			(368,  ' . $db->Quote('highly') . '),
			(369,  ' . $db->Quote('hill') . '),
			(370,  ' . $db->Quote('him') . '),
			(371,  ' . $db->Quote('himself') . '),
			(372,  ' . $db->Quote('his') . '),
			(373,  ' . $db->Quote('hit') . '),
			(374,  ' . $db->Quote('hither') . '),
			(375,  ' . $db->Quote('hold') . '),
			(376,  ' . $db->Quote('hopefully') . '),
			(377,  ' . $db->Quote('hot') . '),
			(378,  ' . $db->Quote('how') . '),
			(379,  ' . $db->Quote('howbeit') . '),
			(380,  ' . $db->Quote('however') . '),
			(381,  ' . $db->Quote('hundred') . '),
			(382,  ' . $db->Quote('i') . '),
			(383,  ' . $db->Quote('i\'d') . '),
			(384,  ' . $db->Quote('i\'ll') . '),
			(385,  ' . $db->Quote('i\'m') . '),
			(386,  ' . $db->Quote('i\'ve') . '),
			(387,  ' . $db->Quote('ie') . '),
			(388,  ' . $db->Quote('if') . '),
			(389,  ' . $db->Quote('ignored') . '),
			(390,  ' . $db->Quote('ill') . '),
			(391,  ' . $db->Quote('immediate') . '),
			(392,  ' . $db->Quote('important') . '),
			(393,  ' . $db->Quote('in') . '),
			(394,  ' . $db->Quote('inasmuch') . '),
			(395,  ' . $db->Quote('inc') . '),
			(396,  ' . $db->Quote('inc.') . '),
			(397,  ' . $db->Quote('include') . '),
			(398, ' . $db->Quote('included') . '),
			(399, ' . $db->Quote('includes') . '),
			(400, ' . $db->Quote('including') . '),
			(401, ' . $db->Quote('indeed') . '),
			(402, ' . $db->Quote('indicate') . '),
			(403, ' . $db->Quote('indicated') . '),
			(404, ' . $db->Quote('indicates') . '),
			(405, ' . $db->Quote('inner') . '),
			(406, ' . $db->Quote('inside') . '),
			(407, ' . $db->Quote('insofar') . '),
			(408, ' . $db->Quote('instead') . '),
			(409, ' . $db->Quote('interest') . '),
			(410, ' . $db->Quote('interested') . '),
			(411, ' . $db->Quote('interesting') . '),
			(412, ' . $db->Quote('interests') . '),
			(413, ' . $db->Quote('into') . '),
			(414, ' . $db->Quote('inward') . '),
			(415, ' . $db->Quote('iron') . '),
			(416, ' . $db->Quote('is') . '),
			(417, ' . $db->Quote('isn\'t') . '),
			(418, ' . $db->Quote('it') . '),
			(419, ' . $db->Quote('it\'d') . '),
			(420, ' . $db->Quote('it\'ll') . '),
			(421, ' . $db->Quote('it\'s') . '),
			(422, ' . $db->Quote('its') . '),
			(423, ' . $db->Quote('itself') . '),
			(424, ' . $db->Quote('j') . '),
			(425, ' . $db->Quote('just') . '),
			(426, ' . $db->Quote('k') . '),
			(427, ' . $db->Quote('keep') . '),
			(428, ' . $db->Quote('keeps') . '),
			(429, ' . $db->Quote('kept') . '),
			(430, ' . $db->Quote('kind') . '),
			(431, ' . $db->Quote('knew') . '),
			(432, ' . $db->Quote('know') . '),
			(433, ' . $db->Quote('known') . '),
			(434, ' . $db->Quote('knows') . '),
			(435, ' . $db->Quote('l') . '),
			(436, ' . $db->Quote('large') . '),
			(437, ' . $db->Quote('largely') . '),
			(438, ' . $db->Quote('last') . '),
			(439, ' . $db->Quote('late') . '),
			(440, ' . $db->Quote('lately') . '),
			(441, ' . $db->Quote('later') . '),
			(442, ' . $db->Quote('latest') . '),
			(443, ' . $db->Quote('latter') . '),
			(444, ' . $db->Quote('latterly') . '),
			(445, ' . $db->Quote('least') . '),
			(446, ' . $db->Quote('led') . '),
			(447, ' . $db->Quote('left') . '),
			(448, ' . $db->Quote('lend') . '),
			(449, ' . $db->Quote('less') . '),
			(450, ' . $db->Quote('lest') . '),
			(451, ' . $db->Quote('let') . '),
			(452, ' . $db->Quote('let\'s') . '),
			(453, ' . $db->Quote('lets') . '),
			(454, ' . $db->Quote('like') . '),
			(455, ' . $db->Quote('liked') . '),
			(456, ' . $db->Quote('likely') . '),
			(457, ' . $db->Quote('likewise') . '),
			(458, ' . $db->Quote('little') . '),
			(459, ' . $db->Quote('localhost') . '),
			(460, ' . $db->Quote('lone') . '),
			(461, ' . $db->Quote('long') . '),
			(462, ' . $db->Quote('longer') . '),
			(463, ' . $db->Quote('longest') . '),
			(464, ' . $db->Quote('look') . '),
			(465, ' . $db->Quote('looking') . '),
			(466, ' . $db->Quote('looks') . '),
			(467, ' . $db->Quote('lot') . '),
			(468, ' . $db->Quote('low') . '),
			(469, ' . $db->Quote('lower') . '),
			(470, ' . $db->Quote('ltd') . '),
			(471, ' . $db->Quote('m') . '),
			(472, ' . $db->Quote('made') . '),
			(473, ' . $db->Quote('mainly') . '),
			(474, ' . $db->Quote('make') . '),
			(475, ' . $db->Quote('makes') . '),
			(476, ' . $db->Quote('making') . '),
			(477, ' . $db->Quote('man') . '),
			(478, ' . $db->Quote('many') . '),
			(479, ' . $db->Quote('may') . '),
			(480, ' . $db->Quote('maybe') . '),
			(481, ' . $db->Quote('mayn\'t') . '),
			(482, ' . $db->Quote('me') . '),
			(483, ' . $db->Quote('mean') . '),
			(484, ' . $db->Quote('meantime') . '),
			(485, ' . $db->Quote('meanwhile') . '),
			(486, ' . $db->Quote('member') . '),
			(487, ' . $db->Quote('members') . '),
			(488, ' . $db->Quote('men') . '),
			(489, ' . $db->Quote('merely') . '),
			(490, ' . $db->Quote('met') . '),
			(491, ' . $db->Quote('might') . '),
			(492, ' . $db->Quote('mightn\'t') . '),
			(493, ' . $db->Quote('mile') . '),
			(494, ' . $db->Quote('mine') . '),
			(495, ' . $db->Quote('minus') . '),
			(496, ' . $db->Quote('miss') . '),
			(497, ' . $db->Quote('moon') . '),
			(498, ' . $db->Quote('more') . '),
			(499, ' . $db->Quote('moreover') . '),
			(500, ' . $db->Quote('most') . '),
			(501, ' . $db->Quote('mostly') . '),
			(502, ' . $db->Quote('move') . '),
			(503, ' . $db->Quote('mr') . '),
			(504, ' . $db->Quote('mrs') . '),
			(505, ' . $db->Quote('much') . '),
			(506, ' . $db->Quote('must') . '),
			(507, ' . $db->Quote('mustn\'t') . '),
			(508, ' . $db->Quote('my') . '),
			(509, ' . $db->Quote('myself') . '),
			(510, ' . $db->Quote('n') . '),
			(511, ' . $db->Quote('name') . '),
			(512, ' . $db->Quote('namely') . '),
			(513, ' . $db->Quote('nd') . '),
			(514, ' . $db->Quote('near') . '),
			(515, ' . $db->Quote('nearly') . '),
			(516, ' . $db->Quote('necessary') . '),
			(517, ' . $db->Quote('need') . '),
			(518, ' . $db->Quote('needed') . '),
			(519, ' . $db->Quote('needing') . '),
			(520, ' . $db->Quote('needn\'t') . '),
			(521, ' . $db->Quote('needs') . '),
			(522, ' . $db->Quote('neither') . '),
			(523, ' . $db->Quote('never') . '),
			(524, ' . $db->Quote('neverf') . '),
			(525, ' . $db->Quote('neverless') . '),
			(526, ' . $db->Quote('nevertheless') . '),
			(527, ' . $db->Quote('new') . '),
			(528, ' . $db->Quote('newer') . '),
			(529, ' . $db->Quote('newest') . '),
			(530, ' . $db->Quote('next') . '),
			(531, ' . $db->Quote('nine') . '),
			(532, ' . $db->Quote('ninety') . '),
			(533, ' . $db->Quote('no') . '),
			(534, ' . $db->Quote('no-one') . '),
			(535, ' . $db->Quote('nobody') . '),
			(536, ' . $db->Quote('non') . '),
			(537, ' . $db->Quote('none') . '),
			(538, ' . $db->Quote('nonetheless') . '),
			(539, ' . $db->Quote('noone') . '),
			(540, ' . $db->Quote('nor') . '),
			(541, ' . $db->Quote('normally') . '),
			(542, ' . $db->Quote('not') . '),
			(543, ' . $db->Quote('note') . '),
			(544, ' . $db->Quote('nothing') . '),
			(545, ' . $db->Quote('notwithstanding') . '),
			(546, ' . $db->Quote('novel') . '),
			(547, ' . $db->Quote('now') . '),
			(548, ' . $db->Quote('nowhere') . '),
			(549, ' . $db->Quote('number') . '),
			(550, ' . $db->Quote('numbers') . '),
			(551, ' . $db->Quote('o') . '),
			(552, ' . $db->Quote('obviously') . '),
			(553, ' . $db->Quote('of') . '),
			(554, ' . $db->Quote('off') . '),
			(555, ' . $db->Quote('often') . '),
			(556, ' . $db->Quote('oh') . '),
			(557, ' . $db->Quote('ok') . '),
			(558, ' . $db->Quote('okay') . '),
			(559, ' . $db->Quote('old') . '),
			(560, ' . $db->Quote('older') . '),
			(561, ' . $db->Quote('oldest') . '),
			(562, ' . $db->Quote('on') . '),
			(563, ' . $db->Quote('once') . '),
			(564, ' . $db->Quote('one') . '),
			(565, ' . $db->Quote('one\'s') . '),
			(566, ' . $db->Quote('ones') . '),
			(567, ' . $db->Quote('only') . '),
			(568, ' . $db->Quote('onto') . '),
			(569, ' . $db->Quote('open') . '),
			(570, ' . $db->Quote('opened') . '),
			(571, ' . $db->Quote('opening') . '),
			(572, ' . $db->Quote('opens') . '),
			(573, ' . $db->Quote('opposite') . '),
			(574, ' . $db->Quote('or') . '),
			(575, ' . $db->Quote('order') . '),
			(576, ' . $db->Quote('ordered') . '),
			(577, ' . $db->Quote('ordering') . '),
			(578, ' . $db->Quote('orders') . '),
			(579, ' . $db->Quote('other') . '),
			(580, ' . $db->Quote('others') . '),
			(581, ' . $db->Quote('otherwise') . '),
			(582, ' . $db->Quote('ought') . '),
			(583, ' . $db->Quote('oughtn\'t') . '),
			(584, ' . $db->Quote('our') . '),
			(585, ' . $db->Quote('ours') . '),
			(586, ' . $db->Quote('ourselves') . '),
			(587, ' . $db->Quote('out') . '),
			(588, ' . $db->Quote('outside') . '),
			(589, ' . $db->Quote('over') . '),
			(590, ' . $db->Quote('overall') . '),
			(591, ' . $db->Quote('own') . '),
			(592, ' . $db->Quote('p') . '),
			(593, ' . $db->Quote('part') . '),
			(594, ' . $db->Quote('parted') . '),
			(595, ' . $db->Quote('particular') . '),
			(596, ' . $db->Quote('particularly') . '),
			(597, ' . $db->Quote('parting') . '),
			(598, ' . $db->Quote('parts') . '),
			(599, ' . $db->Quote('past') . '),
			(600, ' . $db->Quote('per') . '),
			(601, ' . $db->Quote('perhaps') . '),
			(602, ' . $db->Quote('place') . '),
			(603, ' . $db->Quote('placed') . '),
			(604, ' . $db->Quote('places') . '),
			(605, ' . $db->Quote('please') . '),
			(606, ' . $db->Quote('plus') . '),
			(607, ' . $db->Quote('point') . '),
			(608, ' . $db->Quote('pointed') . '),
			(609, ' . $db->Quote('pointing') . '),
			(610, ' . $db->Quote('points') . '),
			(611, ' . $db->Quote('possible') . '),
			(612, ' . $db->Quote('prepare') . '),
			(613, ' . $db->Quote('present') . '),
			(614, ' . $db->Quote('presented') . '),
			(615, ' . $db->Quote('presenting') . '),
			(616, ' . $db->Quote('presents') . '),
			(617, ' . $db->Quote('presumably') . '),
			(618, ' . $db->Quote('probable') . '),
			(619, ' . $db->Quote('probably') . '),
			(620, ' . $db->Quote('problem') . '),
			(621, ' . $db->Quote('problems') . '),
			(622, ' . $db->Quote('provided') . '),
			(623, ' . $db->Quote('provides') . '),
			(624, ' . $db->Quote('pull') . '),
			(625, ' . $db->Quote('pure') . '),
			(626, ' . $db->Quote('push') . '),
			(627, ' . $db->Quote('put') . '),
			(628, ' . $db->Quote('puts') . '),
			(629, ' . $db->Quote('q') . '),
			(630, ' . $db->Quote('que') . '),
			(631, ' . $db->Quote('quite') . '),
			(632, ' . $db->Quote('qv') . '),
			(633, ' . $db->Quote('r') . '),
			(634, ' . $db->Quote('raise') . '),
			(635, ' . $db->Quote('ran') . '),
			(636, ' . $db->Quote('rather') . '),
			(637, ' . $db->Quote('rd') . '),
			(638, ' . $db->Quote('re') . '),
			(639, ' . $db->Quote('reach') . '),
			(640, ' . $db->Quote('realize') . '),
			(641, ' . $db->Quote('really') . '),
			(642, ' . $db->Quote('reasonably') . '),
			(643, ' . $db->Quote('recent') . '),
			(644, ' . $db->Quote('recently') . '),
			(645, ' . $db->Quote('regarding') . '),
			(646, ' . $db->Quote('regardless') . '),
			(647, ' . $db->Quote('regards') . '),
			(648, ' . $db->Quote('relatively') . '),
			(649, ' . $db->Quote('reply') . '),
			(650, ' . $db->Quote('require') . '),
			(651, ' . $db->Quote('respectively') . '),
			(652, ' . $db->Quote('rest') . '),
			(653, ' . $db->Quote('right') . '),
			(654, ' . $db->Quote('room') . '),
			(655, ' . $db->Quote('rooms') . '),
			(656, ' . $db->Quote('round') . '),
			(657, ' . $db->Quote('run') . '),
			(658, ' . $db->Quote('s') . '),
			(659, ' . $db->Quote('said') . '),
			(660, ' . $db->Quote('same') . '),
			(661, ' . $db->Quote('sat') . '),
			(662, ' . $db->Quote('saw') . '),
			(663, ' . $db->Quote('say') . '),
			(664, ' . $db->Quote('saying') . '),
			(665, ' . $db->Quote('says') . '),
			(666, ' . $db->Quote('second') . '),
			(667, ' . $db->Quote('secondly') . '),
			(668, ' . $db->Quote('seconds') . '),
			(669, ' . $db->Quote('see') . '),
			(670, ' . $db->Quote('seeing') . '),
			(671, ' . $db->Quote('seem') . '),
			(672, ' . $db->Quote('seemed') . '),
			(673, ' . $db->Quote('seeming') . '),
			(674, ' . $db->Quote('seems') . '),
			(675, ' . $db->Quote('seen') . '),
			(676, ' . $db->Quote('sees') . '),
			(677, ' . $db->Quote('self') . '),
			(678, ' . $db->Quote('sell') . '),
			(679, ' . $db->Quote('selves') . '),
			(680, ' . $db->Quote('sensible') . '),
			(681, ' . $db->Quote('sent') . '),
			(682, ' . $db->Quote('separate') . '),
			(683, ' . $db->Quote('serious') . '),
			(684, ' . $db->Quote('seriously') . '),
			(685, ' . $db->Quote('set') . '),
			(686, ' . $db->Quote('seven') . '),
			(687, ' . $db->Quote('several') . '),
			(688, ' . $db->Quote('shall') . '),
			(689, ' . $db->Quote('shan\'t') . '),
			(690, ' . $db->Quote('she') . '),
			(691, ' . $db->Quote('she\'d') . '),
			(692, ' . $db->Quote('she\'ll') . '),
			(693, ' . $db->Quote('she\'s') . '),
			(694, ' . $db->Quote('should') . '),
			(695, ' . $db->Quote('shouldn\'t') . '),
			(696, ' . $db->Quote('show') . '),
			(697, ' . $db->Quote('showed') . '),
			(698, ' . $db->Quote('showing') . '),
			(699, ' . $db->Quote('shows') . '),
			(700, ' . $db->Quote('side') . '),
			(701, ' . $db->Quote('sides') . '),
			(702, ' . $db->Quote('sign') . '),
			(703, ' . $db->Quote('since') . '),
			(704, ' . $db->Quote('six') . '),
			(705, ' . $db->Quote('small') . '),
			(706, ' . $db->Quote('smaller') . '),
			(707, ' . $db->Quote('smallest') . '),
			(708, ' . $db->Quote('so') . '),
			(709, ' . $db->Quote('sold') . '),
			(710, ' . $db->Quote('some') . '),
			(711, ' . $db->Quote('somebody') . '),
			(712, ' . $db->Quote('someday') . '),
			(713, ' . $db->Quote('somehow') . '),
			(714, ' . $db->Quote('someone') . '),
			(715, ' . $db->Quote('something') . '),
			(716, ' . $db->Quote('sometime') . '),
			(717, ' . $db->Quote('sometimes') . '),
			(718, ' . $db->Quote('somewhat') . '),
			(719, ' . $db->Quote('somewhere') . '),
			(720, ' . $db->Quote('soon') . '),
			(721, ' . $db->Quote('sorry') . '),
			(722, ' . $db->Quote('specified') . '),
			(723, ' . $db->Quote('specify') . '),
			(724, ' . $db->Quote('specifying') . '),
			(725, ' . $db->Quote('state') . '),
			(726, ' . $db->Quote('states') . '),
			(727, ' . $db->Quote('stay') . '),
			(728, ' . $db->Quote('step') . '),
			(729, ' . $db->Quote('stick') . '),
			(730, ' . $db->Quote('still') . '),
			(731, ' . $db->Quote('stood') . '),
			(732, ' . $db->Quote('sub') . '),
			(733, ' . $db->Quote('such') . '),
			(734, ' . $db->Quote('sudden') . '),
			(735, ' . $db->Quote('sup') . '),
			(736, ' . $db->Quote('suppose') . '),
			(737, ' . $db->Quote('sure') . '),
			(738, ' . $db->Quote('t') . '),
			(739, ' . $db->Quote('t\'s') . '),
			(740, ' . $db->Quote('take') . '),
			(741, ' . $db->Quote('taken') . '),
			(742, ' . $db->Quote('taking') . '),
			(743, ' . $db->Quote('talk') . '),
			(744, ' . $db->Quote('tall') . '),
			(745, ' . $db->Quote('tell') . '),
			(746, ' . $db->Quote('ten') . '),
			(747, ' . $db->Quote('tends') . '),
			(748, ' . $db->Quote('th') . '),
			(749, ' . $db->Quote('than') . '),
			(750, ' . $db->Quote('thank') . '),
			(751, ' . $db->Quote('thanks') . '),
			(752, ' . $db->Quote('thanx') . '),
			(753, ' . $db->Quote('that') . '),
			(754, ' . $db->Quote('that\'ll') . '),
			(755, ' . $db->Quote('that\'s') . '),
			(756, ' . $db->Quote('that\'ve') . '),
			(757, ' . $db->Quote('thats') . '),
			(758, ' . $db->Quote('the') . '),
			(759, ' . $db->Quote('their') . '),
			(760, ' . $db->Quote('theirs') . '),
			(761, ' . $db->Quote('them') . '),
			(762, ' . $db->Quote('themselves') . '),
			(763, ' . $db->Quote('then') . '),
			(764, ' . $db->Quote('thence') . '),
			(765, ' . $db->Quote('there') . '),
			(766, ' . $db->Quote('there\'d') . '),
			(767, ' . $db->Quote('there\'ll') . '),
			(768, ' . $db->Quote('there\'re') . '),
			(769, ' . $db->Quote('there\'s') . '),
			(770, ' . $db->Quote('there\'ve') . '),
			(771, ' . $db->Quote('thereafter') . '),
			(772, ' . $db->Quote('thereby') . '),
			(773, ' . $db->Quote('therefore') . '),
			(774, ' . $db->Quote('therein') . '),
			(775, ' . $db->Quote('theres') . '),
			(776, ' . $db->Quote('thereupon') . '),
			(777, ' . $db->Quote('these') . '),
			(778, ' . $db->Quote('they') . '),
			(779, ' . $db->Quote('they\'d') . '),
			(780, ' . $db->Quote('they\'ll') . '),
			(781, ' . $db->Quote('they\'re') . '),
			(782, ' . $db->Quote('they\'ve') . '),
			(783, ' . $db->Quote('thing') . '),
			(784, ' . $db->Quote('things') . '),
			(785, ' . $db->Quote('think') . '),
			(786, ' . $db->Quote('thinks') . '),
			(787, ' . $db->Quote('third') . '),
			(788, ' . $db->Quote('thirty') . '),
			(789, ' . $db->Quote('this') . '),
			(790, ' . $db->Quote('thorough') . '),
			(791, ' . $db->Quote('thoroughly') . '),
			(792, ' . $db->Quote('those') . '),
			(793, ' . $db->Quote('though') . '),
			(794, ' . $db->Quote('thought') . '),
			(795, ' . $db->Quote('thoughts') . '),
			(796, ' . $db->Quote('three') . '),
			(797, ' . $db->Quote('through') . '),
			(798, ' . $db->Quote('throughout') . '),
			(799, ' . $db->Quote('thru') . '),
			(800, ' . $db->Quote('thus') . '),
			(801, ' . $db->Quote('till') . '),
			(802, ' . $db->Quote('time') . '),
			(803, ' . $db->Quote('to') . '),
			(804, ' . $db->Quote('today') . '),
			(805, ' . $db->Quote('together') . '),
			(806, ' . $db->Quote('told') . '),
			(807, ' . $db->Quote('tomorrow') . '),
			(808, ' . $db->Quote('too') . '),
			(809, ' . $db->Quote('took') . '),
			(810, ' . $db->Quote('tore') . '),
			(811, ' . $db->Quote('tought') . '),
			(812, ' . $db->Quote('toward') . '),
			(813, ' . $db->Quote('towards') . '),
			(814, ' . $db->Quote('tried') . '),
			(815, ' . $db->Quote('tries') . '),
			(816, ' . $db->Quote('truly') . '),
			(817, ' . $db->Quote('trust') . '),
			(818, ' . $db->Quote('try') . '),
			(819, ' . $db->Quote('trying') . '),
			(820, ' . $db->Quote('turn') . '),
			(821, ' . $db->Quote('turned') . '),
			(822, ' . $db->Quote('turning') . '),
			(823, ' . $db->Quote('turns') . '),
			(824, ' . $db->Quote('twice') . '),
			(825, ' . $db->Quote('two') . '),
			(826, ' . $db->Quote('u') . '),
			(827, ' . $db->Quote('un') . '),
			(828, ' . $db->Quote('under') . '),
			(829, ' . $db->Quote('underneath') . '),
			(830, ' . $db->Quote('undoing') . '),
			(831, ' . $db->Quote('unfortunately') . '),
			(832, ' . $db->Quote('unless') . '),
			(833, ' . $db->Quote('unlike') . '),
			(834, ' . $db->Quote('unlikely') . '),
			(835, ' . $db->Quote('until') . '),
			(836, ' . $db->Quote('unto') . '),
			(837, ' . $db->Quote('up') . '),
			(838, ' . $db->Quote('upon') . '),
			(839, ' . $db->Quote('upwards') . '),
			(840, ' . $db->Quote('us') . '),
			(841, ' . $db->Quote('use') . '),
			(842, ' . $db->Quote('used') . '),
			(843, ' . $db->Quote('useful') . '),
			(844, ' . $db->Quote('uses') . '),
			(845, ' . $db->Quote('using') . '),
			(846, ' . $db->Quote('usual') . '),
			(847, ' . $db->Quote('usually') . '),
			(848, ' . $db->Quote('v') . '),
			(849, ' . $db->Quote('value') . '),
			(850, ' . $db->Quote('various') . '),
			(851, ' . $db->Quote('verb') . '),
			(852, ' . $db->Quote('versus') . '),
			(853, ' . $db->Quote('very') . '),
			(854, ' . $db->Quote('via') . '),
			(855, ' . $db->Quote('visit') . '),
			(856, ' . $db->Quote('viz') . '),
			(857, ' . $db->Quote('vs') . '),
			(858, ' . $db->Quote('w') . '),
			(859, ' . $db->Quote('want') . '),
			(860, ' . $db->Quote('wanted') . '),
			(861, ' . $db->Quote('wanting') . '),
			(862, ' . $db->Quote('wants') . '),
			(863, ' . $db->Quote('was') . '),
			(864, ' . $db->Quote('wasn\'t') . '),
			(865, ' . $db->Quote('way') . '),
			(866, ' . $db->Quote('ways') . '),
			(867, ' . $db->Quote('we') . '),
			(868, ' . $db->Quote('we\'d') . '),
			(869, ' . $db->Quote('we\'ll') . '),
			(870, ' . $db->Quote('we\'re') . '),
			(871, ' . $db->Quote('we\'ve') . '),
			(872, ' . $db->Quote('welcome') . '),
			(873, ' . $db->Quote('well') . '),
			(874, ' . $db->Quote('wells') . '),
			(875, ' . $db->Quote('went') . '),
			(876, ' . $db->Quote('were') . '),
			(877, ' . $db->Quote('weren\'t') . '),
			(878, ' . $db->Quote('what') . '),
			(879, ' . $db->Quote('what\'ll') . '),
			(880, ' . $db->Quote('what\'s') . '),
			(881, ' . $db->Quote('what\'ve') . '),
			(882, ' . $db->Quote('whatever') . '),
			(883, ' . $db->Quote('when') . '),
			(884, ' . $db->Quote('whence') . '),
			(885, ' . $db->Quote('whenever') . '),
			(886, ' . $db->Quote('where') . '),
			(887, ' . $db->Quote('where\'s') . '),
			(888, ' . $db->Quote('whereafter') . '),
			(889, ' . $db->Quote('whereas') . '),
			(890, ' . $db->Quote('whereby') . '),
			(891, ' . $db->Quote('wherein') . '),
			(892, ' . $db->Quote('whereupon') . '),
			(893, ' . $db->Quote('wherever') . '),
			(894, ' . $db->Quote('whether') . '),
			(895, ' . $db->Quote('which') . '),
			(896, ' . $db->Quote('whichever') . '),
			(897, ' . $db->Quote('while') . '),
			(898, ' . $db->Quote('whilst') . '),
			(899, ' . $db->Quote('white') . '),
			(900, ' . $db->Quote('whither') . '),
			(901, ' . $db->Quote('who') . '),
			(902, ' . $db->Quote('who\'d') . '),
			(903, ' . $db->Quote('who\'ll') . '),
			(904, ' . $db->Quote('who\'s') . '),
			(905, ' . $db->Quote('whoever') . '),
			(906, ' . $db->Quote('whole') . '),
			(907, ' . $db->Quote('whom') . '),
			(908, ' . $db->Quote('whomever') . '),
			(909, ' . $db->Quote('whose') . '),
			(910, ' . $db->Quote('why') . '),
			(911, ' . $db->Quote('will') . '),
			(912, ' . $db->Quote('willing') . '),
			(913, ' . $db->Quote('wish') . '),
			(914, ' . $db->Quote('with') . '),
			(915, ' . $db->Quote('within') . '),
			(916, ' . $db->Quote('without') . '),
			(917, ' . $db->Quote('won\'t') . '),
			(918, ' . $db->Quote('wonder') . '),
			(919, ' . $db->Quote('work') . '),
			(920, ' . $db->Quote('worked') . '),
			(921, ' . $db->Quote('working') . '),
			(922, ' . $db->Quote('works') . '),
			(923, ' . $db->Quote('would') . '),
			(924, ' . $db->Quote('wouldn\'t') . '),
			(925, ' . $db->Quote('x') . '),
			(926, ' . $db->Quote('y') . '),
			(927, ' . $db->Quote('year') . '),
			(928, ' . $db->Quote('years') . '),
			(929, ' . $db->Quote('yes') . '),
			(930, ' . $db->Quote('yet') . '),
			(931, ' . $db->Quote('you') . '),
			(932, ' . $db->Quote('you\'d') . '),
			(933, ' . $db->Quote('you\'ll') . '),
			(934, ' . $db->Quote('you\'re') . '),
			(935, ' . $db->Quote('you\'ve') . '),
			(936, ' . $db->Quote('young') . '),
			(937, ' . $db->Quote('younger') . '),
			(938, ' . $db->Quote('youngest') . '),
			(939, ' . $db->Quote('your') . '),
			(940, ' . $db->Quote('yours') . '),
			(941, ' . $db->Quote('yourself') . '),
			(942, ' . $db->Quote('yourselves') . '),
			(943, ' . $db->Quote('z') . '),
			(944, ' . $db->Quote('zero') . ');';
		$db->setQuery($fill_stopwords_table_sql);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
		} else {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = '<p style="color: #006600">' . JText::_('Filled') . '</p>';		
		}
		return $status;
	}

}

?>