<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import library dependencies
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');	

class SMMSInstaller {
	function install_sitemodule (&$installer, $modulename, $title, &$db, $install_status, $position = 'left') { 
		// Set the installation path
		$element =& $installer->manifest->getElementByPath('modules/' . $modulename . '/files');
		if (is_a($element, 'JSimpleXMLElement') && count($element->children())) {
			$files =& $element->children();
			foreach ($files as $file) {
				if ($file->attributes('module')) {
					$mname = $file->attributes('module');
					break;
				}
			}
		}
	
		if (!empty ($mname)) {
			$ROOT_PATH = JPATH_SITE;
			$installer->parent->setPath('extension_root', $ROOT_PATH . DS . 'modules' . DS . $mname);
		} else {
			$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': ' . JText::_('No module file specified'));
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('No module file specified') . '</p>';		
			return $install_status;
		}

		/*
		* If the module directory already exists, then we will assume that the
		* module is already installed or another module is using that
		* directory.
		*/
		if (file_exists($installer->parent->getPath('extension_root')) && !$installer->parent->getOverwrite()) {
			$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': ' . JText::_('Another module is already using directory') . ': "' . $installer->parent->getPath('extension_root') . '"');
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Another module is already using directory') . '</p>';		
			return $install_status;
		}
	
		// If the module directory does not exist, lets create it
		$created = false;
		if (!file_exists($installer->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($installer->parent->getPath('extension_root'))) {
				$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': '
										. JText::_('Failed to create directory') . ': "' 
										. $installer->parent->getPath('extension_root') . '"');
				$install_status[$modulename]->name = $modulename;
				$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Failed to create directory') . '</p>';		
				return $install_status;
			}
		}
	
		/*
		* Since we created the module directory and will want to remove it if
		* we have to roll back the installation, lets add it to the
		* installation step stack
		*/
		if ($created) {
			$installer->parent->pushStep(array ('type' => 'folder', 'path' => $installer->parent->getPath('extension_root')));
		}
	
		// Copy all necessary files
		if ($installer->parent->parseFiles($element, -1) === false) {
			// Install failed, roll back changes
			$installer->parent->abort();
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Unable to parse files for copying') . '</p>';		
			return $install_status;
		}
	
		$clientId 			= 0;
		$row 				=& JTable::getInstance('module');
		$row->title 		= $title;
		$row->ordering 		= $row->getNextOrder( "position='" . $position . "'" );
		$row->position 		= $position;
		$row->showtitle 	= 1;
		$row->iscore 		= 0;
		$row->access 		= $clientId == 1 ? 2 : 0;
		$row->client_id 	= $clientId;
		$row->module 		= $mname;
		$row->published 	= 1;
		$row->params 		= '';
	
		if (!$row->store()) {
			// Install failed, roll back changes
			$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': ' . $db->stderr(true));
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Unable to write module information to database') . '</p>';		
			return $install_status;
		}
	
		$install_status[$modulename]->name = $modulename;
		$install_status[$modulename]->text = JText::_('Installed');
		return $install_status;
	}

	function install_adminmodule (&$installer, $modulename, $title, &$db, $install_status, $position = 'left') { 
		// Set the installation path
		$element =& $installer->manifest->getElementByPath('modules/' . $modulename . '/files');
		if (is_a($element, 'JSimpleXMLElement') && count($element->children())) {
			$files =& $element->children();
			foreach ($files as $file) {
				if ($file->attributes('module')) {
					$mname = $file->attributes('module');
					break;
				}
			}
		}
	
		if (!empty ($mname)) {
			$ROOT_PATH = JPATH_ADMINISTRATOR;
			$installer->parent->setPath('extension_root', $ROOT_PATH . DS . 'modules' . DS . $mname);
		} else {
			$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': ' . JText::_('No module file specified'));
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('No module file specified') . '</p>';		
			return $install_status;
		}

		/*
		* If the module directory already exists, then we will assume that the
		* module is already installed or another module is using that
		* directory.
		*/
		if (file_exists($installer->parent->getPath('extension_root')) && !$installer->parent->getOverwrite()) {
			$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': ' . JText::_('Another module is already using directory') . ': "' . $installer->parent->getPath('extension_root') . '"');
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Another module is already using the directory') . '</p>';		
			return $install_status;
		}
	
		// If the module directory does not exist, lets create it
		$created = false;
		if (!file_exists($installer->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($installer->parent->getPath('extension_root'))) {
				$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': '
										. JText::_('Failed to create directory') . ': "' 
										. $installer->parent->getPath('extension_root') . '"');
				$install_status[$modulename]->name = $modulename;
				$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Failed to create directory') . '</p>';		
				return $install_status;
			}
		}
	
		/*
		* Since we created the module directory and will want to remove it if
		* we have to roll back the installation, lets add it to the
		* installation step stack
		*/
		if ($created) {
			$installer->parent->pushStep(array ('type' => 'folder', 'path' => $installer->parent->getPath('extension_root')));
		}
	
		// Copy all necessary files
		if ($installer->parent->parseFiles($element, -1) === false) {
			// Install failed, roll back changes
			$installer->parent->abort();
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Unable to parse files for copying') . '</p>';		
			return $install_status;
		}
	
		$clientId 			= 1;
		$row 				=& JTable::getInstance('module');
		$row->title 		= $title;
		$row->ordering 		= $row->getNextOrder( "position='" . $position . "'" );
		$row->position 		= $position;
		$row->showtitle 	= 0;
		$row->iscore 		= 1;
		$row->access 		= 2;
		$row->client_id 	= 1;
		$row->module 		= $mname;
		$row->published 	= 1;
		$row->params 		= '';
	
		if (!$row->store()) {
			// Install failed, roll back changes
			$installer->parent->abort(JText::_('Module') . ' ' . JText::_('Install') . ': ' . $db->stderr(true));
			$install_status[$modulename]->name = $modulename;
			$install_status[$modulename]->text = '<p style="color: #600000">' . JText::_('Unable to write module information to database') . '</p>';		
			return $install_status;
		}
	
		$install_status[$modulename]->name = $modulename;
		$install_status[$modulename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		return $install_status;
	}

	function install_plugin(&$installer, $pluginname, $title, $group = 'content', &$db, $install_status) { 
		// Set the installation path
		$element =& $installer->manifest->getElementByPath('plugins/' . $pluginname . '/files');
		if (is_a($element, 'JSimpleXMLElement') && count($element->children())) {
			$files =& $element->children();
			foreach ($files as $file) {
				if ($file->attributes('plugin')) {
					$pname = $file->attributes('plugin');
					break;
				}
			}
		}
		
		if (!empty ($pname) && !empty($group)) {
			$installer->parent->setPath('extension_root', JPATH_ROOT . DS . 'plugins' . DS . $group);
		} else {
			$install_status[$pluginname]->name = $pluginname;
			$install_status[$pluginname]->text = '<p style="color: #600000">' . JText::_('No plugin file specified') . '</p>';		
			return $install_status;
		}
	
		// If the plugin directory does not exist, lets create it
		$created = false;
		if (!file_exists($installer->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($installer->parent->getPath('extension_root'))) {
				$install_status[$pluginname]->name = $pluginname;
				$install_status[$pluginname]->text = '<p style="color: #600000">' . JText::_('Failed to create directory') . '</p>';		
				return $install_status;
			}	
		}
	
		/*
		* If we created the plugin directory and will want to remove it if we
		* have to roll back the installation, lets add it to the installation
		* step stack
		*/
		if ($created) {
			$installer->parent->pushStep(array ('type' => 'folder', 'path' => $installer->parent->getPath('extension_root')));
		}
	
		// Copy all necessary files
		if ($installer->parent->parseFiles($element, -1) === false) {
			// Install failed, roll back changes
			$installer->parent->abort();
			$install_status[$pluginname]->name = $pluginname;
			$install_status[$pluginname]->text = '<p style="color: #600000">' . JText::_('Unable to parse files for copying') . '</p>';		
			return $install_status;
		}
	
		// Check to see if a plugin by the same name is already installed
		$query = 'SELECT `id`' .
				' FROM `#__plugins`' .
				' WHERE folder = '.$db->Quote($group) .
				' AND element = '.$db->Quote($pname);
		$db->setQuery($query);
		if (!$db->Query()) {
			// Install failed, roll back changes
			$installer->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.$db->stderr(true));
			$install_status[$pluginname]->name = $pluginname;
			$install_status[$pluginname]->text = '<p style="color: #600000">' . JText::_('Unable to query database') . '</p>';		
			return $install_status;
		}
		$id = $db->loadResult();
	
		// Was there a plugin already installed with the same name?
		if ($id) {
			if (!$installer->parent->getOverwrite())
			{
				// Install failed, roll back changes
				$installer->parent->abort(JText::_('Plugin') . ' ' . JText::_('Install') . ': ' . JText::_('Plugin') . ' "' . $pname . '" ' . JText::_('already exists!'));
				$install_status[$pluginname]->name = $pluginname;
				$install_status[$pluginname]->text = '<p style="color: #600000">' . JText::_('Plugin is already installed') . '</p>';		
				return $install_status;
			}	
		} else {
			$row =& JTable::getInstance('plugin');
			$row->name = $title;
			$row->ordering = 0;
			$row->folder = $group;
			$row->iscore = 0;
			$row->access = 0;
			$row->client_id = 0;
			$row->element = $pname;
			$row->published = 1;
			$row->params = '';
		
			if (!$row->store()) {
				// Install failed, roll back changes
				$installer->parent->abort(JText::_('Plugin') . ' ' . JText::_('Install') . ': ' . $db->stderr(true));
				$install_status[$pluginname]->name = $pluginname;
				$install_status[$pluginname]->text = '<p style="color: #600000">' . JText::_('Unable to write plugin information to database') . '</p>';		
				return $install_status;
			}
		}
		$install_status[$pluginname]->name = $pluginname;
		$install_status[$pluginname]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		return $install_status;
	}

	function install_component($db, $install_status) {
		$install_status['com_smms']->name = 'com_smms';
		$install_status['com_smms']->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';		
		return $install_status;
	}

}

?>