<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once(JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_smms' . DS . 'tables' . DS . 'smmsextension.php');
require_once(JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_installer' . DS . 'models' . DS . 'install.php');

class SMMSInstaller extends JObject {

	function __construct(&$parent) {
		$this->parent =& $parent;
	}

	function install() {
		// Get a database connector object
		$db =& $this->parent->getDBO();

		// Get the extension manifest object
		$manifest =& $this->parent->getManifest();
		$this->manifest =& $manifest->document;

		// Set the extensions name
		$name =& $this->manifest->getElementByPath('name');
		$name = JFilterInput::clean($name->data(), 'cmd');
		$this->set('name', $name);

		// Get the component description
		$description = & $this->manifest->getElementByPath('description');
		if (is_a($description, 'JSimpleXMLElement')) {
			$this->parent->set('message', $description->data());
		} else {
			$this->parent->set('message', '' );
		}

		$type = $this->manifest->attributes('type');

		// Set the installation path
		$element =& $this->manifest->getElementByPath('files');
		if (is_a($element, 'JSimpleXMLElement') && count($element->children())) {
			$files =& $element->children();
			foreach ($files as $file) {
				if ($file->attributes($type)) {
					$pname = $file->attributes($type);
					break;
				}
			}
		}

		if ( !empty ($pname) ) {
			$this->parent->setPath('extension_root', JPATH_ROOT . DS . 'administrator/components/com_smms/extensions');
		} else {
			$this->parent->abort(JText::_('SMMS_GLOBAL_ERROR_NOEXTENSIONFILE'));
			return false;
		}

		// If the extension directory does not exist, lets create it
		$created = false;
		if (!file_exists($this->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($this->parent->getPath('extension_root'))) {
				$this->parent->abort(JText::_('SMMS_GLOBAL_ERROR_FAILTOCREATEDIRECTORY').': "'.$this->parent->getPath('extension_root').'"');
				return false;
			}
		}

		if ($created) {
			$this->parent->pushStep(array ('type' => 'folder', 'path' => $this->parent->getPath('extension_root')));
		}

		// Copy all necessary files
		if ($this->parent->parseFiles($element, -1) === false) {
			// Install failed, roll back changes
			$this->parent->abort();
			return false;
		}

		$ename = str_replace('ext_', '', $pname);
		$ename = str_replace('ext.', '', $ename);
		
		// Check to see if a extension by the same name is already installed
		$query = 'SELECT `id`' .
				' FROM `#__smms_modules`' .
				' WHERE name = '.$db->Quote($ename);
		$db->setQuery($query);
		if (!$db->Query()) {
			// Install failed, roll back changes
			$this->parent->abort(JText::_('SMMS_GLOBAL_ERROR_EXTENSIONINSTALL') . $db->stderr(true));
			return false;
		}
		$id = $db->loadResult();

		// Was there a module already installed with the same name?
		if ($id) {
			if (!$this->parent->getOverwrite()) {
				// Install failed, roll back changes
				$this->parent->abort('SMMS_GLOBAL_ERROR_EXTENSIONALREADYEXISTS' );
				return false;
			}
		} else {
				// Check to see if there is a backup for this extension
				$query = 'SELECT `id`' .
						 ' FROM `#__smms_modules`' .
						 ' WHERE name = '.$db->Quote($ename. '.bak');
				$db->setQuery($query);
				if (!$db->Query()) {
				
				// Install failed, roll back changes
				$this->parent->abort(JText::_('SMMS_GLOBAL_ERROR_EXTENSIONINSTALL') . $db->stderr(true));
				return false;
			}
			$id = $db->loadResult();

			$x_category 			=& $this->manifest->getElementByPath('smms_install/database/category');
			$x_databasename 		=& $this->manifest->getElementByPath('smms_install/database/databasename');
			$x_pregmatch 			=& $this->manifest->getElementByPath('smms_install/database/pregmatch');
			$x_pregmatch2 			=& $this->manifest->getElementByPath('smms_install/database/pregmatch2');
			$x_html		 			=& $this->manifest->getElementByPath('smms_install/database/html');
			$x_formfield 			=& $this->manifest->getElementByPath('smms_install/database/formfield');
			$x_databasefield		=& $this->manifest->getElementByPath('smms_install/database/databasefield');
			$x_sqlselect 			=& $this->manifest->getElementByPath('smms_install/database/sqlselect');
			$x_sqljoin	 			=& $this->manifest->getElementByPath('smms_install/database/sqljoin');
			$x_sqlupdatewithvalue	=& $this->manifest->getElementByPath('smms_install/database/sqlupdatewithvalue');
			$x_sqlupdatenovalue		=& $this->manifest->getElementByPath('smms_install/database/sqlupdatenovalue');

			$row = new SMMSExtension($db, $id);
			
			$row->name 					= $ename;
			$row->enabled 				= 0;
			$row->category 				= $x_category->data();
			$row->databasename 			= $x_databasename->data();
			$row->pregmatch 			= $x_pregmatch->data();
			$row->pregmatch2 			= $x_pregmatch2->data();
			$row->html		 			= $x_html->data();
			$row->formfield 			= $x_formfield->data();
			$row->databasefield			= $x_databasefield->data();
			$row->sqlselect 			= $x_sqlselect->data();
			$row->sqljoin	 			= $x_sqljoin->data();
			$row->sqlupdatewithvalue	= $x_sqlupdatewithvalue->data();
			$row->sqlupdatenovalue		= $x_sqlupdatenovalue->data();
			
			if (!$row->store()) {
				// Install failed, roll back changes
				$this->parent->abort(JText::_('SMMS_GLOBAL_ERROR_EXTENSIONINSTALL') . $db->stderr(true));
				return false;
			}

			// Create module settings
			$fieldname = $this->manifest->attributes('name');
			$fieldtype = $this->manifest->attributes('fieldtype');

			// Set the installation path
			$settings_element =& $this->manifest->getElementByPath('settings');
			if (is_a($settings_element, 'JSimpleXMLElement') && count($settings_element->children())) {
				$settings =& $settings_element->children();
				foreach ($settings as $setting) {
					if ($setting->attributes('name')) {
						$query	= 'INSERT IGNORE INTO ' . $db->nameQuote('#__smms_settings') . ' (' . $db->nameQuote('key') . ', ' . $db->nameQuote('value') . ', ' . $db->nameQuote('field_type') . ') VALUES (' . $db->Quote($setting->attributes('name')) . ', ' . $db->Quote($setting->data()) . ', ' . $db->Quote($setting->attributes('fieldtype')) . ');';					
						$db->setQuery($query);
						if (!$db->query()) {
							JError::raiseError( 500, $db->stderr() );
							return false;
						}
					}
				}
			}

			// Set the installation path
			$defaultvalues_element =& $this->manifest->getElementByPath('default_values');
			if (is_a($defaultvalues_element, 'JSimpleXMLElement') && count($defaultvalues_element->children())) {
				$defaultvalues =& $defaultvalues_element->children();
				foreach ($defaultvalues as $defaultvalue) {
					if ($defaultvalue->attributes('name')) {
						$query	= 'INSERT IGNORE INTO ' . $db->nameQuote('#__smms_defaults') . ' (' . $db->nameQuote('module_id') . ', ' . $db->nameQuote('fieldname') . ', ' . $db->nameQuote('fieldvalue') . ', ' . $db->nameQuote('formfield') . ') VALUES (' . $db->Quote($row->id) . ', ' . $db->Quote($defaultvalue->attributes('name')) . ', ' . $db->Quote($defaultvalue->attributes('value')) . ', ' . $db->Quote($defaultvalue->data()) . ');';					
						$db->setQuery($query);
						if (!$db->query()) {
							JError::raiseError( 500, $db->stderr() );
							return false;
						}
					}
				}
			}			
			// Since we have created a extension item, we add it to the installation step stack
			// so that if we have to rollback the changes we can undo it.
			$this->parent->pushStep(array ('type' => 'smms_ext', 'id' => $row->id));
		}

		// Lastly, we will copy the manifest file to its appropriate place.
		if (!$this->parent->copyManifest(-1)) {
			// Install failed, rollback changes
			$this->parent->abort(JText::_('SMMS_GLOBAL_ERROR_COULDNOTCOPYSETUPFILE'));
			return false;
		}
		return true;
	}

	function uninstall($id, $clientId ) {
		// Initialize variables
		$row	= null;
		$retval = true;
		$db		=& $this->parent->getDBO();

		// First order of business will be to load the module object table from the database.
		// This should give us the necessary information to proceed.
		$row = new SMMSExtension($db,(int) $id);
		// Set the extension root path
		$this->parent->setPath('extension_root', JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions');

		// Because extensions don't have their own folders we cannot use the standard method of finding an installation manifest
		$manifestFile = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions' . DS . 'ext.' . $row->name . '.xml';
		if (file_exists($manifestFile)) {
			$xml =& JFactory::getXMLParser('Simple');

			// If we cannot load the xml file return null
			if (!$xml->loadFile($manifestFile)) {
				JError::raiseWarning(100, JText::_('SMMS_GLOBAL_ERROR_COULDNOTLOADMANIFEST'));
				return false;
			}

			$root =& $xml->document;
			if ($root->name() != 'smms_extension') {
				JError::raiseWarning(101, JText::_('SMMS_GLOBAL_ERROR_INVALIDMANIFEST'));
				return false;
			}

			// Remove the extension files
			$this->parent->removeFiles($root->getElementByPath('images'), -1);
			$this->parent->removeFiles($root->getElementByPath('files'), -1);
			JFile::delete($manifestFile);

			// Remove all media and languages as well
			$this->parent->removeFiles($root->getElementByPath('media'));
			$this->parent->removeFiles($root->getElementByPath('languages'), 1);
		} else {
			JError::raiseWarning(102, JText::_('SMMS_GLOBAL_ERROR_INVALIDMANIFESTORNOTFOUND'));
			return false;
		}

		$query	= 'DELETE FROM ' . $db->nameQuote('#__smms_settings') . ' WHERE ' . $db->nameQuote('key') . ' LIKE ' . $db->Quote($row->name . '_%') . ';';
		$db->setQuery($query);
		if (!$db->query()) {
			JError::raiseError( 500, $db->stderr() );
			return false;
		}
		
		$query	= 'DELETE FROM ' . $db->nameQuote('#__smms_defaults') . ' WHERE ' . $db->nameQuote('fieldname') . ' LIKE ' . $db->Quote('%' . $row->name . '%') . ';';
		$db->setQuery($query);
		if (!$db->query()) {
			JError::raiseError( 500, $db->stderr() );
			return false;
		}

		// Now we will no longer need the extension object, so lets delete it

		$id = $row->id;
		//$row->name = $row->name . '.bak';
		//$row->store();
		unset ($row);

		$this->_rollback_extension($id);
	}

	function _rollback_extension($id) {
		// Get database connector object
		$db =& $this->parent->getDBO();

		// Remove the entry from the #__modules table
		$query = 'DELETE' .
				' FROM ' . $db->nameQuote('#__smms_modules') .
				' WHERE id=' . $db->Quote((int)$id);
		$db->setQuery($query);
		return ($db->query() !== false);
	}
}

?>