<?php
/**
* FeedGator - Aggregate RSS newsfeed content into a Joomla! database
* @version 2.3.2
* @package FeedGator
* @author Matt Faulds
* @email mattfaulds@gmail.com
* @copyright (C) 2010 Matthew Faulds - All rights reserved
* @license GNU/GPL: http://www.gnu.org/copyleft/gpl.html
*
**/
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

JPluginHelper::importPlugin( 'feedgator' );
jimport('joomla.application.component.model');
JTable::addIncludePath(JPATH_BASE.DS.'components'.DS.'com_feedgator'.DS.'tables');
class FeedgatorModelTools extends JModel
{
	var $_id = null;
	var $_data = null;
	var $_imports = null;
	var $_plugin = null;
	function __construct()
	{
		parent::__construct();
		
		$this->pluginModel = &FGFactory::getPluginModel();
		$this->feedModel = &FGFactory::getFeedModel();
	}
	
	function findDuplicates()
	{
		$plugins_data = &$this->pluginModel->loadInstalledPlugins();
		foreach($plugins_data as $plugin_data) {
			if($plugin_data->published) {
				$this->pluginModel->setExt($plugin_data->extension);
				$plugin = &$this->pluginModel->getPlugin();
				$query = $plugin->findDuplicates('internal',null);
				$this->_db->setQuery($query,0,1);
				if($this->_db->loadResult()) {
					return true;
				}
			}
		}
		return false;
	}
	
	function getDuplicates()
	{
		$plugins_data = &$this->pluginModel->loadInstalledPlugins();
		foreach($plugins_data as $plugin_data) {
			if($plugin_data->published) {
				$this->pluginModel->setExt($plugin_data->extension);
				$plugin = &$this->pluginModel->getPlugin();
				$query[] = $plugin->findDuplicates('internal',null);
			}
		}
		$query = implode(' UNION ',array_filter($query));
		$query .= ' ORDER BY content_type';
		$this->_db->setQuery($query);
		if($dups = $this->_db->loadObjectList()) {
			return $dups;
		}
		return false;
	}
	
	function ignoreDuplicate()
	{
		$rel = JRequest::getCmd('rel','','get');
		$id = substr($rel,strpos($rel,'_')+1);
		$content_type = JRequest::getCmd('type','','get');
		if($rel and $content_type) {
			$this->pluginModel->setExt($content_type);
			$this->pluginModel->getParams(-1);
			$params = $this->pluginModel->_data->paramsArray[-1];
			isset($params['ignore']) ? $params['ignore'] .= ','.$id : $params['ignore'] = $id;
			unset($params['--TXT--']);
			if($this->pluginModel->store(-1,$params)) {
				return true;
			}
		}
		return false;
	}
		
	function checkPlugins()
	{		
		$query = 	'SELECT COUNT(fg.id) AS fgids, COUNT(fgg.id) AS fggids' .
					' FROM #__feedgator AS fg' .
					' INNER JOIN #__feedgator_plugins AS fp ON fg.content_type = fp.extension' .
					' RIGHT JOIN #__feedgator AS fgg ON fg.id = fgg.id';
		$this->_db->setQuery($query);
		$counts = $this->_db->loadRow();
		
		if($counts[0] == $counts[1]) {
			$rows = &$this->pluginModel->loadInstalledPlugins();
			foreach($rows as &$row) {
				if($row->pub_count) {
					return true;
				}
			}
		}

		return false;
	}
	
	function checkImports()
	{
		$count = 0;
		
		$query = 'SELECT * FROM #__feedgator_imports WHERE (content_id != -1 AND content_id != -2)';
		$this->_db->setQuery($query);
		$rows = $this->_db->loadAssocList();
		if(!empty($rows)) {
			foreach($rows as &$row) {
				if($plugin = &$this->pluginModel->getPlugin($row['plugin'])) {
					if(!isset($ids[$row['plugin']]['query'])) $ids[$row['plugin']]['query'] = $plugin->countContentQuery();
					$ids[$row['plugin']]['ids'][] = $row['content_id'];
				}
			}
			if(isset($ids)) {
				foreach($ids as $content_type => &$data) {
					$query = sprintf($data['query'],implode(',',$data['ids']));
					$this->_db->setQuery($query);
					$count += $this->_db->loadResult();
				}
			}
			$total = count($rows);
		} else {
			$total = 0;
		}
		
		return ($total == $count);
	}
	
	function syncImports()
	{
		$app = &JFactory::getApplication();
		$msg = '<h4>'.JText::_('Import Synchronisation').'</h4>';
		
		$query = 'SELECT * FROM #__feedgator_imports WHERE (content_id != -1 AND content_id != -2)';
		$this->_db->setQuery($query);
		$rows = $this->_db->loadAssocList();
		foreach($rows as &$row) {
			if($plugin = &$this->pluginModel->getPlugin($row['plugin'])) {
				if(!$plugin->getContentItem($row['content_id'])) {
					$ids[] = $row['id'];
				}
			} else {
				$msg .= 'Unable to sync imports using '.$row['plugin'];
			}
		}
		if(isset($ids)) {
			$total = count($ids);
			$ids = implode(',',$ids);
			$query = 'DELETE FROM #__feedgator_imports WHERE id IN ('.$ids.')';
			$this->_db->setQuery($query);
			$this->_db->loadResult();
		}
		isset($total) ? $msg .= $total.JText::_(' log entries deleted!') : $msg .= JText::_('No log entries deleted!');
		$app->redirect('index.php?option=com_feedgator&task=tools',$msg);
	}
}