<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');
?>
<table cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td valign="top" width="50%">
			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_TITLE' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_ENABLE_IMAGE_MANAGER' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_ENABLE_IMAGE_MANAGER_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_ENABLE_IMAGE_MANAGER' ); ?>
					</span>
					</td>
					<td valign="top" class="value">
						<?php echo $this->renderCheckbox( 'main_imagemanager' , $this->config->get( 'main_imagemanager' ) );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_ALLOWED_EXTENSIONS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_ALLOWED_EXTENSIONS_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_ALLOWED_EXTENSIONS' ); ?>
					</span>
					</td>
					<td valign="top" class="value">
						<input type="text" class="input inputbox" style="width: 300px;" value="<?php echo $this->config->get( 'main_media_extensions' );?>" id="media_extensions" name="main_media_extensions" />
						<input type="button" value="<?php echo JText::_( 'COM_EASYBLOG_RESET_DEFAULT' );?>" onclick="sQuery('#media_extensions').val('jpg,png,gif,pdf,zip,doc,docx,mp4,flv,mov,wmv,avi');" />
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_MAX_FILESIZE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_MAX_FILESIZE_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_MAX_FILESIZE' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="main_upload_image_size" class="inputbox" style="width: 50px;text-align:center;" value="<?php echo $this->config->get('main_upload_image_size', '0' );?>" />
						<?php echo JText::_( 'COM_EASYBLOG_MEGABYTES' );?>
						<div><?php echo JText::sprintf( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_UPLOAD_PHP_MAXSIZE' , ini_get( 'upload_max_filesize') ); ?></div>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_UPLOADER_TYPE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_UPLOADER_TYPE_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_UPLOADER_TYPE' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php
	  						$options = array();
  							$options[]	= JHTML::_('select.option', 'html4' , JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_UPLOADER_TYPE_HTML' ) );
  							$options[]	= JHTML::_('select.option', 'flash' , JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_UPLOADER_TYPE_FLASH' ) );
							echo JHTML::_('select.genericlist', $options, 'main_upload_client', 'size="1" class="inputbox"', 'value', 'text' , $this->config->get('main_upload_client' ) );
						?>
					</td>
				</tr>
				</tbody>
			</table>
			</fieldset>
			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_STORAGE_TITLE' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_AVATAR_PATH' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_AVATAR_PATH_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_AVATAR_PATH' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="main_avatarpath" class="inputbox" style="width: 260px;" value="<?php echo $this->config->get('main_avatarpath', 'images/eblog_avatar/' );?>" />
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_CATEGORY_PATH' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_CATEGORY_PATH_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_CATEGORY_PATH' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="main_categoryavatarpath" class="inputbox" style="width: 260px;" value="<?php echo $this->config->get('main_categoryavatarpath', 'images/eblog_cavatar/' );?>" />
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_TEAMBLOG_PATH' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_TEAMBLOG_PATH_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_TEAMBLOG_PATH' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="main_teamavatarpath" class="inputbox" style="width: 260px;" value="<?php echo $this->config->get('main_teamavatarpath', 'images/eblog_tavatar/' );?>" />
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_PATH' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_PATH_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGE_PATH' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="main_image_path" class="inputbox" style="width: 260px;" value="<?php echo $this->config->get('main_image_path', 'images/easyblog_images/' );?>" />
					</td>
				</tr>
				</tbody>
			</table>
			</fieldset>
		</td>
		<td valign="top">
			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_IMAGES_TITLE' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_RESIZE_IMAGE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_RESIZE_IMAGE_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_RESIZE_IMAGE' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php echo $this->renderCheckbox( 'main_resize_image_on_upload' , $this->config->get( 'main_resize_image_on_upload' ) );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_MAXIMUM_IMAGE_WIDTH' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_MAXIMUM_IMAGE_WIDTH_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_MAXIMUM_IMAGE_WIDTH' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="main_maximum_image_width" class="inputbox" style="width: 50px;text-align:center;" value="<?php echo $this->config->get('main_maximum_image_width');?>" />
						<?php echo JText::_( 'COM_EASYBLOG_PIXELS' ); ?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_MAXIMUM_IMAGE_HEIGHT' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_MAXIMUM_IMAGE_HEIGHT_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_MAXIMUM_IMAGE_HEIGHT' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="main_maximum_image_height" class="inputbox" style="width: 50px;text-align:center;" value="<?php echo $this->config->get('main_maximum_image_height');?>" />
						<?php echo JText::_( 'COM_EASYBLOG_PIXELS' ); ?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_THUMBNAIL_USE_LIGHTBOX_PREVIEW' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_THUMBNAIL_USE_LIGHTBOX_PREVIEW_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_THUMBNAIL_USE_LIGHTBOX_PREVIEW' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php echo $this->renderCheckbox( 'main_media_lightbox_preview' , $this->config->get( 'main_media_lightbox_preview' ) );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_LIGHTBOX_TITLE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_LIGHTBOX_TITLE_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_LIGHTBOX_TITLE' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php echo $this->renderCheckbox( 'main_media_lightbox_title' , $this->config->get( 'main_media_lightbox_title' ) );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_LIGHTBOX_STRIP_EXTENSION' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_LIGHTBOX_STRIP_EXTENSION_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_LIGHTBOX_STRIP_EXTENSION' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php echo $this->renderCheckbox( 'main_media_lightbox_remove_title' , $this->config->get( 'main_media_lightbox_remove_title' ) );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_UPLOAD_QUALITY' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_UPLOAD_QUALITY_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_UPLOAD_QUALITY' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php
	  						$options = array();

	  						for( $i = 0; $i <= 100; $i += 10 )
	  						{
	  							$message	= $i;
	  							$message	= $i == 0 ? JText::sprintf( 'COM_EASYBLOG_LOWEST_QUALITY_OPTION' , $i ) : $message;
	  							$message	= $i == 50 ? JText::sprintf( 'COM_EASYBLOG_MEDIUM_QUALITY_OPTION' , $i ) : $message;
	  							$message	= $i == 100 ? JText::sprintf( 'COM_EASYBLOG_HIGHEST_QUALITY_OPTION' , $i ) : $message;
	  							$options[]	= JHTML::_('select.option', $i , $message );
	  						}

							echo JHTML::_('select.genericlist', $options, 'main_upload_quality', 'size="1" class="inputbox"', 'value', 'text', $this->config->get('main_upload_quality' ) );
						?>
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_UPLOAD_QUALITY_HINTS' );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_DEFAULT_ALIGNMENT' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_DEFAULT_ALIGNMENT_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_DEFAULT_ALIGNMENT' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php
	  						$options = array();

  							$options[]	= JHTML::_('select.option', 'none' , JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_ALIGN_NOT_SET' ) );
  							$options[]	= JHTML::_('select.option', 'left' , JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_ALIGN_LEFT' ) );
  							$options[]	= JHTML::_('select.option', 'right' , JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_ALIGN_RIGHT' ) );
  							$options[]	= JHTML::_('select.option', 'center' , JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_ALIGN_CENTER' ) );
							echo JHTML::_('select.genericlist', $options, 'main_image_alignment', 'size="1" class="inputbox"', 'value', 'text', $this->config->get('main_image_alignment' ) );
						?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_ALLOW_USER_TO_CHANGE_SETTINGS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_ALLOW_USER_TO_CHANGE_SETTINGS_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_ALLOW_USER_TO_CHANGE_SETTINGS' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php echo $this->renderCheckbox( 'main_image_usersettings' , $this->config->get( 'main_image_usersettings' ) );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_GALLERY_SHOW_ON_FRONTPAGE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_GALLERY_SHOW_ON_FRONTPAGE_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_IMAGE_GALLERY_SHOW_ON_FRONTPAGE' ); ?>
					</span>
					</td>
					<td valign="top">
						<?php echo $this->renderCheckbox( 'main_image_gallery_frontpage' , $this->config->get( 'main_image_gallery_frontpage' ) );?>
					</td>
				</tr>
				</tbody>
			</table>
			</fieldset>
			<fieldset class="adminform">
			<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_MEDIA_VIDEOS_TITLE' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tbody>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_VIDEO_WIDTH' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_VIDEO_WIDTH_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_VIDEO_WIDTH' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="dashboard_video_width" class="inputbox" style="width: 50px;" value="<?php echo $this->config->get('dashboard_video_width' );?>" />
						<?php echo JText::_( 'COM_EASYBLOG_PIXELS' );?>
					</td>
				</tr>
				<tr>
					<td width="300" class="key">
					<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_VIDEO_HEIGHT' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_VIDEO_HEIGHT_DESC'); ?>">
						<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_VIDEO_HEIGHT' ); ?>
					</span>
					</td>
					<td valign="top">
						<input type="text" name="dashboard_video_height" class="inputbox" style="width: 50px;" value="<?php echo $this->config->get('dashboard_video_height' );?>" />
						<?php echo JText::_( 'COM_EASYBLOG_PIXELS' );?>
					</td>
				</tr>
				</tbody>
			</table>
			</fieldset>
		</td>
	</tr>
</table>