<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');
?>

<script type="text/javascript">
sQuery(document).ready(function(){
	eblog.location.init();
});
</script>

<ul class="list-form reset-ul">
	<li>
		<label for="authorId"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_AUTHOR' ); ?></label>
		<div>
			<input type="hidden" name="authorId" id="authorId" value="<?php echo empty($this->author)? $user->id : $this->author->id;?>" />
			<input type="text" readonly="readonly" name="authorName" id="authorName" value="<?php echo empty($this->author)? $user->getName() : $this->author->getName();?>" class="input" />
			<a class="modal-button modal button" rel="{handler: 'iframe', size: {x: 650, y: 375}}" href="index.php?option=com_easyblog&view=users&tmpl=component&browse=1"><?php echo JText::_('COM_EASYBLOG_BROWSE_USERS');?></a>
		</div>
	</li>
	<?php if( $this->teams || EasyBlogHelper::getHelper( 'Groups' )->useGroups() ) { ?>
		<li>
			<label><?php echo JText::_('COM_EASYBLOG_DASHBOARD_WRITE_PUBLISHING_CONTRIBUTION');?> :</label>
			<div>
				<?php if( !$this->external ){ ?>
				<div class="blog-contributions clearfix">
					<input type="radio" name="blog_contribute" id="team_site" value="0" <?php echo ($this->isSiteWide) ? 'checked="checked"' : ''; ?> onclick="eblog.dashboard.changeCollab('easyblog');sQuery( this ).parent().toggleClass( 'active' );" class="input radio" />
					<label for="team_site"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_WRITE_PUBLISHING_CONTRIBUTION_SITE_WIDE'); ?></label>
				</div>
				<?php } ?>

				<?php
				if( $this->teams && !$this->external )
				{
				?>
				<strong><?php echo JText::_( 'COM_EASYBLOG_TEAMS' );?></strong>
				<?php
					foreach( $this->teams as $team )
					{
						$teamTable	= EasyBlogHelper::getTable( 'TeamBlog' );
						$teamTable->load( $team->team_id );

						$isTeamChecked  = false;
						if( $this->isDraft )
						{
							if( isset($draft->blog_contribute) )
							{
								$isTeamChecked  = ($team->id == $draft->blog_contribute) ? true : false;
							}
						}
						else
						{
							$isTeamChecked  = $teamTable->isPostOwner( $this->blog->id );
						}
				?>
				<div class="blog-contributions clearfix mts">
					<input type="radio" name="blog_contribute" id="team_<?php echo $teamTable->id;?>" value="<?php echo $teamTable->id;?>" onclick="eblog.dashboard.changeCollab('easyblog');sQuery( this ).parent().toggleClass( 'active' );"<?php echo ($isTeamChecked) ? ' checked="checked"' : ''; ?> class="input radio" />
					<label for="team_<?php echo $teamTable->id;?>"><img src="<?php echo $teamTable->getAvatar();?>" width="30" height="30" class="avatar float-l mrm" /><?php echo $teamTable->title;?></label>
				</div>
				<?php
					}
				}
				?>

				<?php
				$groups	= EasyBlogHelper::getHelper( 'Groups' )->getFormHTML( $this->external, $this->extGroupId );

				if( $groups )
				{
				?>
					<strong><?php echo JText::_( 'COM_EASYBLOG_INTEGRATION_GROUPS' );?></strong>
					<input type="hidden" name="groups_type" value="" />
					<input type="hidden" name="return" value="<?php echo JRequest::getVar( 'return' ); ?>" />
				<?php
					echo $groups;
				}
				?>
			</div>
			<input type="hidden" id="blog_contribute_source" name="blog_contribute_source" value="easyblog" />
		</li>
	<?php } else { ?>
		<input type="hidden" name="blog_contribute" value="0" />
	<?php } ?>
	<li>
		<label for="category_id"><?php echo JText::_('COM_EASYBLOG_BLOGS_SELECT_CATEGORY'); ?></label>
		<div>
			<input type="text" readonly="readonly" name="categoryTitle" id="categoryTitle" value="<?php echo $this->category->title;?>" class="inputbox" />
			<input type="hidden" value="<?php echo $this->category->id;?>" name="category_id" id="category_id" />
			<a class="modal-button modal button" rel="{handler: 'iframe', size: {x: 650, y: 375}}" href="index.php?option=com_easyblog&view=categories&tmpl=component&browse=1&p=1"><?php echo JText::_('COM_EASYBLOG_SELECT_CATEGORY');?></a>
		</div>
	</li>
	<li>
		<label for="published"><?php echo JText::_('COM_EASYBLOG_BLOGS_PUBLISHING_STATUS'); ?></label>
		<div>
			<select name="published" id="published" class="inputbox" style="width: 150px;">
				<option value="1" <?php if($this->blog->published == "1") echo "selected='selected'"; ?>><?php echo JText::_('COM_EASYBLOG_PUBLISHED');?></option>
				<option value="0" <?php if($this->blog->published == "0") echo "selected='selected'"; ?>><?php echo JText::_('COM_EASYBLOG_UNPUBLISHED');?></option>
			</select>
		</div>
	</li>
	<li>
		<label for="blog_contribute"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_CONTRIBUTION');?></label>
		<div>
			<?php if( $this->external ) { ?>
				<input type="radio" name="blog_contribute" value="<?php echo $this->extGroupId;?>" checked/><?php echo $this->extGroupName; ?>
			<?php } else { ?>
				<input type="radio" name="blog_contribute" value="0" <?php echo ($this->isSiteWide) ? 'checked' : ''; ?> /> <?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_CONTRIBUTION_SITE'); ?>
				<?php foreach( $this->teamBlogJoined as $team ) {	?>
					<input type="radio" name="blog_contribute" value="<?php echo $team->team_id;?>" <?php echo ($team->selected) ? 'checked' : ''; ?> /><?php echo $team->title;?>
				<?php } ?>
			<?php } ?>
			<input type="hidden" id="blog_contribute_source" name="blog_contribute_source" value="<?php echo $this->blog_contribute_source; ?>" />
		</div>
	</li>
	<li>
		<label for="created"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_CREATION_DATE'); ?></label>
		<div>
			<?php
			$now 		=  EasyBlogDateHelper::toFormat( EasyBlogDateHelper::getDate() );
			$displaynow =  EasyBlogDateHelper::toFormat( EasyBlogDateHelper::getDate(), $this->config->get( 'layout_dateformat' ) );

			if($this->blog->created != "")
			{
				$newDate    = EasyBlogDateHelper::getDate($this->blog->created);
				$now 		= EasyBlogDateHelper::toFormat($newDate);
				$displaynow =  EasyBlogDateHelper::toFormat( $newDate, $this->config->get( 'layout_dateformat' ) );
			}

			echo EasyBlogHelper::dateTimePicker('created', $displaynow, $now);
			?>
		</div>
	</li>
	<li>
		<label for="publish_up"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_PUBLISHING_DATE'); ?></label>
		<div>
			<?php
			if($this->blog->publish_up != "")
			{
				$newDate    = EasyBlogDateHelper::getDate($this->blog->publish_up);
				$now 		= EasyBlogDateHelper::toFormat($newDate);
				$displaynow =  EasyBlogDateHelper::toFormat( $newDate, $this->config->get( 'layout_dateformat' ) );
			}
			else {
				$newDate    	= EasyBlogDateHelper::getDate();
				$now 			= EasyBlogDateHelper::toFormat( $newDate );
				$displaynow 	= EasyBlogDateHelper::toFormat( $newDate, $this->config->get( 'layout_dateformat' ) );
			}

			echo EasyBlogHelper::dateTimePicker('publish_up', $this->blog->publish_up != '' ? $displaynow : JText::_('COM_EASYBLOG_IMMEDIATELY'), $now);
			?>
		</div>
	</li>
	<li>
		<label for="publish_down"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_UNPUBLISHING_DATE'); ?></label>
		<div>
			<?php
			$notEmpty = true;
			if ( $this->blog->publish_down == "0000-00-00 00:00:00" || empty($this->blog->publish_down))
			{
				$newDate    	= EasyBlogDateHelper::getDate($this->blog->publish_down);
				$now			= '';
				$displaynow 	= '';
				$nowReset       = EasyBlogDateHelper::toFormat( $newDate );
				$notEmpty 		= false;
			}
			else {
				$newDate    = EasyBlogDateHelper::getDate($this->blog->publish_down);
				$now 		= EasyBlogDateHelper::toFormat($newDate);
				$nowReset   = EasyBlogDateHelper::toFormat( $newDate );
				$displaynow = EasyBlogDateHelper::toFormat( $newDate, $this->config->get( 'layout_dateformat' ) );
				$notEmpty 	= true;
			}
			echo EasyBlogHelper::dateTimePicker('publish_down', $notEmpty ? $displaynow : JText::_('COM_EASYBLOG_NEVER'), $notEmpty ? $now : '', true);
			?>
			<input type="hidden" name="publish_down_reset" id="publish_down_reset" value="<?php echo $nowReset; ?>"/>
			<input type="hidden" name="publish_down_ori" id="publish_down_ori" value="<?php echo $this->blog->publish_down; ?>"/>
		</div>
	</li>
	<li>
		<label for="location"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_BLOG_LOCATION' );?></label>
		<div>
			<input class="input has-icon width-250 publish-location" type="text" name="address" value="<?php echo $this->blog->address;?>" id="blog-location" autocomplete="off"/>
			<a href="javascript:void(0);" onclick="eblog.location.autoDetect();" class="ui-button"><?php echo JText::_( 'COM_EASYBLOG_LOCATIONS_AUTODETECT' ); ?></a>
			<div class="blog-latlng small" style="<?php echo !isset($this->blog->latitude) ? 'opacity: 0;' : ''; ?>"><?php echo JText::_('COM_EASYBLOG_LATITUDE'); ?>: <span class="blog-lat"><?php echo $this->blog->latitude;?></span>, <?php echo JText::_('COM_EASYBLOG_LONGITUDE'); ?>: <span class="blog-lng"><?php echo $this->blog->longitude;?></span></div>

			<input type="hidden" name="latitude" value="<?php echo $this->blog->latitude;?>" id="blog-latitude" />
			<input type="hidden" name="longitude" value="<?php echo $this->blog->longitude;?>" id="blog-longitude" />
		</div>

		<script type="text/javascript">
			var tmpl = decodeURIComponent('%09%09%09%3Cdiv%20class%3D%22stackSuggest%20location-suggestion%22%3E%0A%09%09%09%09%3Cul%20class%3D%22stackSuggestList%22%3E%0A%09%09%09%09%09%7B%7Bif%20dataset.length%3E0%7D%7D%0A%09%09%20%20%20%20%09%09%3Cdiv%20class%3D%22stackSuggestItemGroup%22%3E%7B%7Beach(i%2Cdata)%20dataset%7D%7D%3Cli%20class%3D%22stackSuggestItem%22%20dataid%3D%24%7Bdata.%24dataId%7D%3E%24%7Bdata.formatted_address%7D%3C%2Fli%3E%7B%7B%2Feach%7D%7D%3C%2Fdiv%3E%0A%09%09%20%20%20%20%09%09%7B%7B%2Fif%7D%7D%0A%09%09%09%09%3C%2Ful%3E%0A%09%09%09%3C%2Fdiv%3E');

			sQuery(document.createElement("script"))
				.attr({
					'type': 'text/jquery-tmpl',
					'class': 'locationSuggest'
				})
				.html(tmpl)
				.appendTo('body');
		</script>
<!--

		<script type="text/x-jquery-tmpl" class="locationSuggest">
			<div class="stackSuggest location-suggestion">
				<ul class="stackSuggestList">
					{{if dataset.length>0}}
					<div class="stackSuggestItemGroup">{{each(i,data) dataset}}<li class="stackSuggestItem" dataid=${data.$dataId}>${data.formatted_address}</li>{{/each}}</div>
					{{/if}}
				</ul>
			</div>
		</script>

 -->	</li>
	<li>
		<label for="private"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_PERMISSIONS'); ?></label>
		<div>
			<?php
				$nameFormat = array();
			$nameFormat[] = JHTML::_('select.option', '0', JText::_( 'COM_EASYBLOG_PUBLIC' ) );

			if(!empty($this->acl->rules->enable_privacy))
			{
				$nameFormat[] = JHTML::_('select.option', '1', JText::_( 'COM_EASYBLOG_PRIVATE' ) );
			}

			$showdet = JHTML::_('select.genericlist', $nameFormat, 'private', 'size="1" class="inputbox" style="width: 150px;"', 'value', 'text', $this->isPrivate );
			echo $showdet;
			?>
		</div>
	</li>
	<li>
		<label for="allowcomment"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_ENABLE_COMMENT'); ?></label>
		<div>
			<?php echo $this->renderCheckbox( 'allowcomment' , $this->allowComment ); ?>
		</div>
	</li>
	<li>
		<label for="subscription"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_ENABLE_BLOG_SUBSCRIPTION'); ?></label>
		<div>
			<?php echo $this->renderCheckbox( 'subscription' , $this->subscription ); ?>
		</div>
	</li>
	<li>
		<label for="frontpage"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_SHOW_ON_FRONTPAGE'); ?></label>
		<div>
			<?php echo $this->renderCheckbox( 'frontpage' , $this->frontpage ); ?>
		</div>
	</li>
	<li>
		<label for="copyrights"><?php echo JText::_('COM_EASYBLOG_COPYRIGHTS'); ?></label>
		<div>
			<input type="text" name="copyrights" id="copyrights" value="<?php echo $this->blog->copyrights;?>" class="input" />
		</div>
	</li>

	<?php if($this->config->get('main_password_protect') && !$this->blog->isFeatured() ){ ?>
	<li>
		<label for="blogpassword"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_PUBLISHING_PROTECTION'); ?></label>
		<div>
			<input type="text" name="blogpassword" id="blogpassword" value="<?php echo $this->blog->blogpassword;?>" class="input" />
			<label><?php echo JText::_( 'COM_EASYBLOG_BLOGS_BLOG_PUBLISHING_PROTECTION_INSTRUCTIONS' );?></label>
		</div>
	</li>
	<?php } ?>

	<?php if( $this->draft->id  ){ ?>
		<?php
			$autopost	= array();

			if( !empty( $this->draft->autopost) )
			{
				$autopost	= explode( ',' , $this->draft->autopost );
			}
		?>
		<li>
			<label for="socialshare"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_ALSO_PUBLISH_TO' );?></label>
			<div>
				<span class="ui-highlighter publish-to float-l">
					<span class="ui-span" style="display: inline-block;">
						<input style="vertical-align: middle;" type="checkbox" name="socialshare[]" value="facebook" id="socialshare-facebook" onclick="eblog.dashboard.socialshare.setActive( this );"<?php echo in_array( 'facebook' , $autopost ) ? ' checked="checked"' : '';?> />
						<label style="display: inline-block;vertical-align: middle;" for="socialshare-facebook" title="<?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_FACEBOOK' ); ?>"><span class="ir ico-fb"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_FACEBOOK' ); ?></span></label>
					</span>
					<span class="ui-span" style="display: inline-block;">
						<input style="vertical-align: middle;" type="checkbox" name="socialshare[]" value="twitter" id="socialshare-twitter" onclick="eblog.dashboard.socialshare.setActive( this );"<?php echo in_array( 'twitter' , $autopost ) ? ' checked="checked"' : '';?> />
						<label style="display: inline-block;vertical-align: middle;" for="socialshare-twitter" title="<?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_TWITTER' ); ?>"><span class="ir ico-tw"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_TWITTER' ); ?></span></label>
					</span>
					<span class="ui-span" style="display: inline-block;">
						<input style="vertical-align: middle;" type="checkbox" name="socialshare[]" value="linkedin" id="socialshare-linkedin" onclick="eblog.dashboard.socialshare.setActive( this );"<?php echo  in_array( 'linkedin' , $autopost ) ? ' checked="checked"' : '';?> />
						<label style="display: inline-block;vertical-align: middle;" for="socialshare-linkedin" title="<?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_LINKEDIN' ); ?>"><span class="ir ico-ln"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_LINKEDIN' ); ?></span></label>
					</span>
				</span>
			</div>
		</li>
	<?php } else { ?>
		<?php if(
				$this->acl->rules->update_facebook && $this->config->get( 'integrations_facebook' ) && EasyBlogHelper::getHelper( 'SocialShare' )->isAssociated( $this->author->id , 'FACEBOOK' ) ||
				$this->acl->rules->update_twitter && $this->config->get( 'integrations_twitter' ) && EasyBlogHelper::getHelper( 'SocialShare' )->isAssociated( $this->author->id , 'TWITTER' ) ||
				$this->acl->rules->update_linkedin && $this->config->get( 'integrations_linkedin' ) && EasyBlogHelper::getHelper( 'SocialShare' )->isAssociated( $this->author->id , 'LINKEDIN' ) ){
		?>
		<li>
			<label for="socialshare"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_ALSO_PUBLISH_TO' );?></label>
			<div>
				<span class="ui-highlighter publish-to float-l">
					<?php if( $this->acl->rules->update_facebook && $this->config->get( 'integrations_facebook' ) && EasyBlogHelper::getHelper( 'SocialShare' )->isAssociated( $this->author->id , 'FACEBOOK' ) ){?>
					<span class="ui-span" style="display: inline-block;">
						<input style="vertical-align: middle;" type="checkbox" name="socialshare[]" value="facebook" id="socialshare-facebook"<?php echo EasyBlogHelper::getHelper( 'SocialShare' )->hasAutoPost( $this->author->id , 'FACEBOOK' ) ? ' checked="checked"' : '';?> onclick="eblog.dashboard.socialshare.setActive( this );" />
						<label style="display: inline-block;vertical-align: middle;" for="socialshare-facebook" title="<?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_FACEBOOK' ); ?>"><span class="ir ico-fb"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_FACEBOOK' ); ?></span></label>
					</span>
					<?php } ?>
					<?php if( $this->acl->rules->update_twitter && $this->config->get( 'integrations_twitter' ) && EasyBlogHelper::getHelper( 'SocialShare' )->isAssociated( $this->author->id , 'TWITTER' ) ){?>
					<span class="ui-span" style="display: inline-block;">
						<input style="vertical-align: middle;" type="checkbox" name="socialshare[]" value="twitter" id="socialshare-twitter"<?php echo EasyBlogHelper::getHelper( 'SocialShare' )->hasAutoPost( $this->author->id , 'TWITTER' ) ? ' checked="checked"' : '';?> onclick="eblog.dashboard.socialshare.setActive( this );" />
						<label style="display: inline-block;vertical-align: middle;" for="socialshare-twitter" title="<?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_TWITTER' ); ?>"><span class="ir ico-tw"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_TWITTER' ); ?></span></label>
					</span>
					<?php } ?>
					<?php if( $this->acl->rules->update_linkedin && $this->config->get( 'integrations_linkedin' ) && EasyBlogHelper::getHelper( 'SocialShare' )->isAssociated( $this->author->id , 'LINKEDIN' )  ){?>
					<span class="ui-span" style="display: inline-block;">
						<input style="vertical-align: middle;" type="checkbox" name="socialshare[]" value="linkedin" id="socialshare-linkedin"<?php echo EasyBlogHelper::getHelper( 'SocialShare' )->hasAutoPost( $this->author->id , 'LINKEDIN' ) ? ' checked="checked"' : '';?> onclick="eblog.dashboard.socialshare.setActive( this );" />
						<label style="display: inline-block;vertical-align: middle;" for="socialshare-linkedin" title="<?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_LINKEDIN' ); ?>"><span class="ir ico-ln"><?php echo JText::_( 'COM_EASYBLOG_BLOGS_SOCIALSHARE_LINKEDIN' ); ?></span></label>
					</span>
					<?php } ?>
				</span>
			</div>
		</li>
		<?php } ?>
	<?php } ?>
</ul>
