<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

$blog 		= $this->blog;
$draft		= $this->draft;
$editor		= $this->editor;
$acl		= $this->acl;
$author		= $this->author;

$blogId = JRequest::getInt('blogid', '');

$isPrivate = $this->isPrivate;
$allowComment = $this->allowComment;
$subscription = $this->subscription;
$frontpage = $this->frontpage;
$trackbacks = $this->trackbacks;

jimport( 'joomla.utilities.date' );
?>
<script type="text/javascript" src="http://maps.googleapis.com/maps/api/js?sensor=true"></script>
<script type="text/javascript">
<?php if(EasyBlogHelper::getJoomlaVersion() >= 1.6) : ?>
	Joomla.submitbutton = function( action ) {
	
	    if( action == 'rejectBlog')
	    {
			var draft_id    = sQuery('#draft_id').val();
	        admin.blog.reject( draft_id );
			return false;
	    }
	    else
	    {
            eblog.editor.toggleSave();
            saveBlog();

			if( action == 'savePublishNew' )
			{
				sQuery( '#savenew' ).val( '1' );
				action	= 'savePublish';
			}
		}
		Joomla.submitform( action );
    }
<?php else : ?>
function submitbutton( action )
{
    if( action == 'rejectBlog')
    {
		var draft_id    = sQuery('#draft_id').val();
        admin.blog.reject( draft_id );
		return false;
    }
    else
    {
		eblog.editor.toggleSave();
		saveBlog();

		if( action == 'savePublishNew' )
		{
			sQuery( '#savenew' ).val( '1' );
			action	= 'savePublish';
		}
	}

	submitform( action );
}
<?php endif; ?>

function insertMember( id , name )
{
	ej('#authorId').val(id);
	ej('#authorName').val(name);
	
	<?php
	if($this->joomlaversion >= '1.6')
	{
	?>
		window.parent.SqueezeBox.close();
	<?php
	}
	else
	{
	?>
		window.parent.document.getElementById('sbox-window').close();
	<?php
	}
	?>
}

function insertCategory( id , name )
{
	ej('#category_id').val(id);
	ej('#categoryTitle').val(name);
	
	<?php
	if($this->joomlaversion >= '1.6')
	{
	?>
		window.parent.SqueezeBox.close();
	<?php
	}
	else
	{
	?>
		window.parent.document.getElementById('sbox-window').close();
	<?php
	}
	?>
}

sQuery(document).ready( function(){
	sQuery('#title').bind('change', function() {
		eblog.editor.permalink.generate();
	});
	
	// Editor initialization so we can use their methods.
	eblog.editor.getContent = function(){
		<?php echo 'return ' . JFactory::getEditor( $this->config->get( 'layout_editor' ) )->getContent( 'write_content' ); ?>
	}

	eblog.editor.setContent = function( value ){
		<?php echo 'return ' . JFactory::getEditor( $this->config->get( 'layout_editor' ) )->setContent( 'write_content' , 'value' ); ?>
	}

	eblog.editor.toggleSave = function(){
		<?php echo JFactory::getEditor( $this->config->get( 'layout_editor' ) )->save( 'write_content' ); ?>
	}
});

sQuery.sanitizeHTML = function(html)
{
	var fragmentContainer = document.createElement('div'),
	fragment = document.createDocumentFragment();

	sQuery.clean([html], document, fragment);

	fragmentContainer.appendChild(fragment);

	return fragmentContainer.innerHTML;
}

function saveBlog()
{
	// Retrieve the main content.
	var editorContents 	= eblog.editor.getContent();

	// Try to break the parts with the read more.
	var val	= editorContents.split( '<hr id="system-readmore" />' );

	if( val.length > 1 )
	{
		// It has a read more tag
		var intro		= sQuery.sanitizeHTML( val[ 0 ] );
		var fulltext	= sQuery.sanitizeHTML( val[ 1 ] );
		var content 	= intro + '<hr id="system-readmore" />' + fulltext;
	}
	else
	{
		// Since there is no read more tag here, the first index is always the full content.
		var content 	= sQuery.sanitizeHTML( editorContents );
	}
	sQuery( '#write_content_hidden' ).val( content );
}
</script>
<div id="eblog-wrapper">
<form name="adminForm" id="blogForm" method="post" action="index.php">
	<table class="noshow" cellpadding="5" cellspacing="5">
		<tr>
			<td valign="top" width="60%" style="padding-right:30px">
				<ul class="list-form reset-ul">
					<li>
		    			<div class="clearfix"><label for="title" class="fsl ffa fwb"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_TITLE'); ?></label></div>
		    			<div><input type="text" name="title" id="title" value="<?php echo $blog->title; ?>" class="inputbox write-title width-full ffa fsl" /></div>
					</li>
					<li>
		    			<div class="clearfix"><label for="slug" class="fsl ffa fwb"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_PERMALINK'); ?></label></div>
		    			<div><input type="text" name="permalink" id="permalink" value="<?php echo $blog->permalink;?>" class="inputbox write-slug width-full" /></div>
                        <div class="small" style="margin-top:3px"><?php echo JText::_('COM_EASYBLOG_BLOGS_BLOG_PERMALINK_DESC'); ?></div>
				  	</li>
					<li style="margin-top:15px;padding-top:15px;border-top:1px dotted #ddd">
						<div id="editor-write_body">
							<div id="editor-write_content" class="clearfix mbs">
								<div class="clearfix ui-medialink pas">
									<a href="javascript:void(0);" onclick="eblog.dashboard.toggle(this);sQuery(this).toggleClass( 'active' );" class="ir float-l ico-dglobe mrs prel">
										<b class="ir"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_EDITOR_INSERT_LINK_ADD_TO_CONTENT'); ?></b>
										<span class="ui-toolnote">
											<i></i>
											<b><?php echo JText::_('COM_EASYBLOG_DASHBOARD_EDITOR_INSERT_LINK_ADD_TO_CONTENT'); ?></b>
											<span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_EDITOR_INSERT_LINK_ADD_TO_CONTENT_TIPS'); ?></span>
										</span>
									</a>
									<i></i>
							        <?php
							            $this->editorName = 'write_content';
										echo $this->loadTemplate( 'images' );
									?>
									<i></i>
									<a class="ir float-l ico-dvideo prel" href="javascript: void(0);" onclick="eblog.dashboard.videos.showForm('write_content');" title="<?php echo JText::_( 'COM_EASYBLOG_DASHBOARD_WRITE_INSERT_VIDEO' );?>">
										<b class="ir"><?php echo JText::_( 'COM_EASYBLOG_DASHBOARD_WRITE_INSERT_VIDEO' );?></b>
										<span class="ui-toolnote">
											<i></i>
											<b><?php echo JText::_( 'COM_EASYBLOG_DASHBOARD_WRITE_INSERT_VIDEO' );?></b>
											<span><?php echo JText::_( 'COM_EASYBLOG_DASHBOARD_WRITE_INSERT_VIDEO_TIPS' ); ?></span>
										</span>
									</a>
								</div>
								<div style="display:none;" class="mts">
									<div id="" class="pas search-field" style="background:#f5f5f5;border:1px solid #ccc">
							        	<span class="fleft mtm"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_WRITE_SEARCH_PREVIOUS_POST'); ?></span>
							            <div class="tablecell pas mrl">
							                <input type="text" id="search-content-write_content" class="half" />
							                <input type="button" onclick="eblog.editor.search.load('write_content');return false;" value="<?php echo JText::_('COM_EASYBLOG_SEARCH'); ?>" class="ui-button mls" />
							            </div>
									</div>
									<div class="search-results-content"></div>
								</div>
							</div>
							
							<div id="wysiwyg" class="clearfix">
			    				<?php echo $editor->display( 'write_content', $this->content, '100%', '550', '10', '10' , array('pagebreak','ninjazemanta','image') ); ?>
			    				<input id="write_content_hidden" value="" type="hidden" name="write_content_hidden"/>
			    			</div>
			    		</div>
					</li>
				</ul>
			</td>
			<td valign="top" width="38%">
			<?php
				$pane	= JPane::getInstance('sliders', array('allowAllClose' => true));

				echo $pane->startPane("content-pane");
				echo $pane->startPanel( JText::_( 'COM_EASYBLOG_BLOGS_BLOG_PUBLISHING_OPTIONS' ) , "detail-page" );
				echo $this->loadTemplate( 'publishing' );
				echo $pane->endPanel();
				echo $pane->startPanel( JText::_( 'COM_EASYBLOG_BLOGS_BLOG_METADATA' ), "params-page" );
				echo $this->loadTemplate( 'metadata' );
				echo $pane->endPanel();
				echo $pane->startPanel( JText::_( 'COM_EASYBLOG_BLOGS_BLOG_TRACKBACKS' ), "metadata-page" );
				echo $this->loadTemplate( 'trackbacks' );
				echo $pane->endPanel();
				echo $pane->startPanel( JText::_( 'COM_EASYBLOG_BLOGS_BLOG_TAGS' ), "metadata-page" );
				echo $this->loadTemplate( 'tagging' );
				echo $pane->endPanel();
				
				if( $this->config->get( 'layout_dashboard_zemanta' ) && $this->config->get( 'layout_dashboard_zemanta_api') != '' )
				{
					echo $pane->startPanel( JText::_( 'COM_EASYBLOG_BLOGS_BLOG_ZEMANTA' ), "zemanta-page" );
					echo $this->loadTemplate( 'zemanta' );
					echo $pane->endPanel();
				}
				
				echo $pane->endPane();
			?>
			</td>
		</tr>
	</table>
<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="savenew" value="0" id="savenew" />
<input type="hidden" name="ispending" value="<?php echo $acl->rules->publish_entry ? '0' : '1'; ?>" />
<input type="hidden" name="option" value="com_easyblog" />
<input type="hidden" name="c" value="blogs" />
<input type="hidden" name="task" value="save" />
<input type="hidden" name="metaid" value="<?php echo $this->meta->id; ?>" />
<input type="hidden" name="blogid" value="<?php echo $blog->id;?>" />
<input type="hidden" name="draft_id" id="draft_id" value="<?php echo $draft->id;?>" />
<input type="hidden" name="under_approval" value="<?php echo $this->pending_approval; ?>" />
</form>
</div>