<?php
/**
* @package   _symphony Template
* @version   1.5.2 2009-11-05 11:26:17
* @author    theme http://www.theme.com
* @copyright Copyright (C) 2007 - 2009 theme GmbH
*/

/*
	Class: Template
		Provides advanced templating functions.
*/

class Template {

	/* document */
	var $document;

	/* base url */
	var $url;

	/* parameters */
	var $params;

	/* browser */
	var $browser = array();

	function Template() {

		// set params
		$this->params = new TemplateParameter();
		$this->params->loadFile(dirname(dirname(dirname(__FILE__))).'/params.ini');
		$this->params->loadPageSuffix();
		
		// ie browser
		if (array_key_exists('HTTP_USER_AGENT', $_SERVER) && preg_match('/(MSIE\\s?([\\d\\.]+))/', $_SERVER['HTTP_USER_AGENT'], $matches)) {
			$this->browser['ie7'] = intval($matches[2]) == 7;
			$this->browser['ie6'] = intval($matches[2]) == 6;
		}		
	}

	function &getInstance() {
		static $instance;

		if ($instance == null) {
			$instance = new Template();
		}
		
		return $instance;
	}

	function setDocument(&$document) {
		$this->document =& $document;
		$this->url = $document->baseurl.'/templates/'.$document->template;
	}

	/* Browser */

	function isIe($version) {
		if (array_key_exists('ie'.$version, $this->browser)) {
			return $this->browser['ie'.$version];
		}
		return false;
	}

}

/*
	Class: TemplateParameter
		Template parameter.
*/
class TemplateParameter {

	/* parameters */
	var $params = array();

	function TemplateParameter($data = null) {
		$this->parseString($data);
	}

	function get($key, $default = '') {

		if (array_key_exists($key, $this->params)) {
			return $this->params[$key];
		}

		return $default;
	}

	function set($key, $value) {
		$this->params[$key] = $value;
	}

	function toArray() {
		return $this->params;
	}

	function loadFile($file) {

		// read parameters from file
		if (is_file($file)) {
			$handle = fopen($file, 'r');
			if ($handle !== false) {
				while ($l = fgets($handle)) {
					if (preg_match('/^#/', $l) == false) {
						if (preg_match('/^(.*?)=(.*?)$/', $l, $regs)) {
							$this->params[$regs[1]] = $regs[2];
						}
					}
				}
				@fclose($handle);
			}
		}
	}

	function loadPageSuffix() {
		global $mainframe;

		// read parameters from joomla page class suffix
		if (isset($mainframe)) {
			$params =& $mainframe->getParams();
			$this->parseString($params->get('pageclass_sfx'));
		}
	}

	function parseString($string) {
		$parts = preg_split('/[\s]+/', $string);

		foreach ($parts as $part) {
			if (strpos($part, '-') !== false) {
				list($key, $value) = split('-', $part, 2);
				$this->params[$key] = $value;
			}
		}
	}

}